#include <stdlib.h>
#include <clutter/clutter.h>

int
main (int argc, char *argv[])
{
  clutter_init (&argc, &argv);

  ClutterScript *ui = clutter_script_new ();

  gchar *filename = "test.json";
  GError *error = NULL;

  /* load a JSON file into the script */
  clutter_script_load_from_file (ui, filename, &error);

  if (error != NULL)
    {
      g_critical ("Error loading ClutterScript file %s\n%s", filename, error->message);
      g_error_free (error);
      exit (EXIT_FAILURE);
    }

  /* retrieve objects from the script */
  ClutterActor *stage = clutter_stage_get_default();
  clutter_actor_set_size(stage, 400, 200);
  ClutterActor *test;

  clutter_script_get_objects (ui,
                              "test", &test,
                              NULL);
  clutter_container_add_actor(stage, test);
	
  clutter_actor_show (stage);

  clutter_main ();

  return EXIT_SUCCESS;
}

