#include <mx/mx.h>

static gboolean press_cb(ClutterActor* actor, ClutterEvent* event, gpointer data)
{
	printf("press event\n");
	return FALSE;
}

static gboolean release_cb(ClutterActor* actor, ClutterEvent* event, gpointer data)
{
	printf("release event\n");
	return FALSE;
}

int main (int argc, char **argv)
{
	clutter_init(&argc, &argv);
	ClutterActor *stage;
	gint width, height;
	MxAdjustment *hadjust, *vadjust;
	ClutterActor *scroll, *kinetic, *view, *texture;

	stage = clutter_stage_get_default();
	kinetic = mx_kinetic_scroll_view_new ();
	clutter_container_add_actor(CLUTTER_CONTAINER(stage), kinetic);
	view = mx_viewport_new ();
	mx_viewport_set_sync_adjustments (MX_VIEWPORT (view), FALSE);
	clutter_container_add_actor (CLUTTER_CONTAINER (kinetic), view);
	texture = clutter_texture_new_from_file ("redhand.png", NULL);
	clutter_actor_set_reactive(texture, TRUE);
	g_signal_connect(G_OBJECT(texture), "button-press-event", G_CALLBACK(press_cb), NULL);
	g_signal_connect(G_OBJECT(texture), "button-release-event", G_CALLBACK(release_cb), NULL);
	clutter_container_add_actor (CLUTTER_CONTAINER (view), texture);
	g_object_set (texture, "repeat-x", TRUE, "repeat-y", TRUE, NULL);
	clutter_actor_set_size (texture, 1280, 1280);
	
	clutter_texture_get_base_size (CLUTTER_TEXTURE (texture), &width, &height);
	mx_scrollable_get_adjustments (MX_SCROLLABLE (view), &hadjust, &vadjust);
	mx_adjustment_set_values (hadjust, 0, 0, 0, width, width * 3, 300);
	mx_adjustment_set_values (vadjust, 0, 0, 1200, height, height * 3, 300);
	clutter_actor_show_all(stage);
	clutter_main();
}
