# - try to find LIBINTL include files
#  LIBINTL_INCLUDE_DIR, where to find GL/LIBINTL.h, etc.
#  LIBINTL_FOUND, If false, do not try to use LIBINTL.

  IF (APPLE)
    # These values for Apple could probably do with improvement.
    FIND_PATH( LIBINTL_INCLUDE_DIR libintl.h
      ${LIBINTL_ROOT_PATH}/include
      )
    FIND_LIBRARY( LIBINTL_LIBINTL_LIBRARY NAMES intl
      PATHS
      ${LIBINTL_ROOT_PATH}/lib/
      )
  ELSE (APPLE)
    FIND_PATH( LIBINTL_INCLUDE_DIR libintl.h
      ${LIBINTL_ROOT_PATH}/include
      )
    FIND_LIBRARY( LIBINTL_LIBINTL_LIBRARY NAMES intl
      PATHS
      ${LIBINTL_ROOT_PATH}/lib/
      )
  ENDIF (APPLE)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(LIBINTL
                                  REQUIRED_VARS LIBINTL_LIBINTL_LIBRARY LIBINTL_INCLUDE_DIR)

IF (LIBINTL_FOUND)
  SET( LIBINTL_LIBRARIES
    ${LIBINTL_LIBINTL_LIBRARY}
    )
  SET (LIBINTL_INCLUDE_PATH ${LIBINTL_INCLUDE_DIR})
ELSE(LIBINTL_FOUND)
  MESSAGE("LIBINTL NOT FOUND!!!")
ENDIF(LIBINTL_FOUND)

MARK_AS_ADVANCED(
  LIBINTL_INCLUDE_DIR
  LIBINTL_LIBINTL_LIBRARY
  )
