#include <iostream>
#include <string>
#include <libintl.h>
#include <locale.h>
#include <assert.h>

int main(int argc, char **argv)
{
    // setup localization
    std::string localePath;
    char* locpath = getenv("LOCPATH");
    std::cout << "getenv(LOCPATH): " << (locpath?locpath:"NULL") << std::endl;
    if(!locpath)
    {
        char* cwd = getenv("PWD");
        std::cout << "getenv(PWD): " << (cwd?cwd:"NULL") << std::endl;
        assert(cwd);
        if(cwd)
        {
            localePath = cwd;
        }
        else 
        {
            localePath = ".";
        }
        localePath += "/locale";
    }
    else
    {
        localePath = locpath;
    }
    char* l = getenv("LANG");
    std::cout << "getenv(LANG): " << (l?l:"NULL") << std::endl;
    char* s = setlocale(LC_ALL, "");
    std::cout << "setlocale(): " << (s?s:"NULL") << std::endl;
    std::cout << "bindtextdomain(): " << bindtextdomain("messages", localePath.c_str()) << std::endl;
    std::cout << "textdomain(): " << textdomain( "messages") << std::endl;
    std::cout << gettext("hello, world!") << std::endl;
    
    return EXIT_SUCCESS;
}