<?xml version="1.0" encoding="UTF-8"?>

<xsl:stylesheet
	xmlns:esql="http://apache.org/cocoon/SQL/v2"
	xmlns:ferienwelt="http://office.ferienwelt.com.pl/ferienwelt"
	xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
	xmlns:xsp="http://apache.org/xsp"
	>

	<xsl:template match="ferienwelt:dests">
	
		<esql:connection>
			<esql:pool>fp</esql:pool>

			<esql:execute-query>
				<esql:query>SELECT * FROM loc</esql:query>

				<!-- got results -->
				<esql:results>
					<esql:row-results>
						<xsp:element name="destination">
							<xsp:attribute name="id">
								<esql:get-int column="id_loc"/>
							</xsp:attribute>
							<xsp:attribute name="sup-id">
								<esql:get-int column="sup_loc"/>
							</xsp:attribute>
							<xsp:element name="name">
								<esql:get-string column="name_loc"/>
							</xsp:element>
							<xsp:element name="short-info">
								<esql:get-string column="short_info_loc"/>
							</xsp:element>
						</xsp:element>
					</esql:row-results>
				</esql:results>
			</esql:execute-query>
		</esql:connection>
	</xsl:template>

	<xsl:template match="ferienwelt:hotels">
		<xsp:logic>
			String destination_id = request.getParameter ("destination");
			String query;
			if (destination_id == null) {
				query = "SELECT * FROM hotel";
			}	else {
				query = "SELECT * FROM hotel WHERE loc_ref_hotel = " + destination_id;
			}
		</xsp:logic>
		<esql:connection>
			<esql:pool>fp</esql:pool>

			<esql:execute-query>
				<esql:query><xsp:expr>query</xsp:expr><!--SELECT * FROM hotel--></esql:query>
				<esql:results>
					<esql:row-results>
						<xsp:element name="hotel">
							<xsp:attribute name="id">
								<esql:get-int column="id_hotel"/>
							</xsp:attribute>
							
							<xsp:attribute name="class">
								<esql:get-string column="class_hotel"/>
							</xsp:attribute>

							<xsp:attribute name="destination">
								<esql:get-int column="loc_ref_hotel"/>
							</xsp:attribute>

							<xsp:element name="name">
								<esql:get-string column="name_hotel"/>
							</xsp:element>

							<xsp:element name="short-info">
								<esql:get-string column="short_info_hotel"/>
							</xsp:element>
						</xsp:element>
					</esql:row-results>
				</esql:results>
			</esql:execute-query>
		</esql:connection>
	</xsl:template>

	<!-- detailed destination info -->
	<xsl:template match="ferienwelt:destination">
		<xsp:logic>
			String destination_id=request.getParameter ("destination");
			if (destination_id == null) {
				destination_id = "1";
			}
		</xsp:logic>
		<esql:connection>
			<esql:pool>fp</esql:pool>
			<esql:execute-query>
				<esql:query>SELECT * FROM loc WHERE id_loc = <!--<esql:parameter type="string">--><xsp:expr>destination_id</xsp:expr><!--</esql:parameter>--></esql:query>
				<esql:results>
					<esql:row-results>
						<xsp:element name="destination-information">
							<xsp:attribute name="id">
								<esql:get-int column="id_loc"/>
							</xsp:attribute>
							<xsp:attribute name="name">
								<esql:get-string column="name_loc"/>
							</xsp:attribute>
							<xsp:attribute name="short-info">
								<esql:get-string column="short_info_loc"/>
							</xsp:attribute>
							<xsp:attribute name="sup-id">
								<esql:get-int column="sup_loc"/>
							</xsp:attribute>
							
							<esql:execute-query>
								<esql:query>SELECT * FROM info_loc WHERE ref_loc_info_loc = <esql:parameter type="int"><esql:get-int ancestor="1" column="id_loc"/></esql:parameter></esql:query>
								<esql:results>
									<esql:row-results>
										<xsp:element name="info">
											<xsp:attribute name="id">
												<esql:get-int column="id_info_loc"/>
											</xsp:attribute>
											<xsp:attribute name="sup-id">
												<esql:get-int column="sup_info_loc"/>
											</xsp:attribute>
											<xsp:attribute name="destination">
												<esql:get-int column="ref_loc_info_loc"/>
											</xsp:attribute>
											
											<xsp:element name="name">
												<esql:get-string column="name_info_loc"/>
											</xsp:element>
											<xsp:element name="value">
												<esql:get-string column="value_info_loc"/>
											</xsp:element>
										</xsp:element> <!-- end of info element -->
									</esql:row-results>
								</esql:results>
							</esql:execute-query>
						</xsp:element> <!-- end of destination-information element -->
					</esql:row-results>
				</esql:results>
			</esql:execute-query>
		</esql:connection>
	</xsl:template>
	
	<xsl:template match="ferienwelt:hotel-info">
		<xsp:logic>
			String hotel_id=request.getParameter("hotel");
			if (hotel_id == null) {
				hotel_id = "1";
			}
		</xsp:logic>
		<esql:connection>
			<esql:pool>fp</esql:pool>
			<esql:execute-query>
				<esql:query>SELECT * FROM hotel WHERE id_hotel = <!--<esql:parameter type="string">--><xsp:expr>hotel_id</xsp:expr><!--</esql:parameter>--></esql:query>
				<esql:results>
					<esql:row-results>
						<xsp:element name="hotel">
							<xsp:attribute name="id">
								<esql:get-int column="id_hotel"/>
							</xsp:attribute>
							<xsp:attribute name="name">
								<esql:get-string column="name_hotel"/>
							</xsp:attribute>
							<xsp:attribute name="short-info">
								<esql:get-string column="short_info_hotel"/>
							</xsp:attribute>
							<xsp:attribute name="class">
								<esql:get-float column="class_hotel"/>
							</xsp:attribute>
							<xsp:attribute name="destination">
								<esql:get-int column="loc_ref_hotel"/>
							</xsp:attribute>
							
							<!-- detailed info on hotel -->
							<esql:execute-query>
								<esql:query>SELECT * FROM info_hotel WHERE ref_hotel_info_hotel = <esql:parameter type="int"><esql:get-int ancestor="1" column="id_hotel"/></esql:parameter></esql:query>
								<esql:results>
									<esql:row-results>
										<xsp:element name="info">
											<xsp:attribute name="id">
												<esql:get-int column="id_info_hotel"/>
											</xsp:attribute>
											<xsp:attribute name="sup-id">
												<esql:get-int column="sup_info_hotel"/>
											</xsp:attribute>
											<xsp:attribute name="hotel">
												<esql:get-int column="ref_hotel_info_hotel"/>
											</xsp:attribute>
											<xsp:element name="name">
												<esql:get-string column="name_info_hotel"/>
											</xsp:element>
											<xsp:element name="value">
												<esql:get-string column="value_info_hotel"/>
											</xsp:element>
										</xsp:element> <!-- end of info element -->
									</esql:row-results>
								</esql:results>
							</esql:execute-query>
						</xsp:element> <!-- end of hotel element -->
					</esql:row-results>
				</esql:results>
			</esql:execute-query>
		</esql:connection>
	</xsl:template>
	
	<xsl:template match="@*|node()" priority="-1">
		<xsl:copy>
			<xsl:apply-templates select="@*|node()"/>
		</xsl:copy>
	</xsl:template>
</xsl:stylesheet>
