/*
 * Decompiled with CFR 0.152.
 */
package cli1;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;

public class HelpFormatter {
    public static final int DEFAULT_WIDTH = 80;
    public static final int DEFAULT_LEFT_PAD = 1;
    public static final int DEFAULT_DESC_PAD = 3;
    public static final String DEFAULT_SYNTAX_PREFIX = "usage: ";
    public static final String DEFAULT_OPT_PREFIX = "-";
    public static final String DEFAULT_LONG_OPT_PREFIX = "--";
    public static final String DEFAULT_ARG_NAME = "arg";
    public int defaultWidth = 80;
    public int defaultLeftPad = 1;
    public int defaultDescPad = 3;
    public String defaultSyntaxPrefix = "usage: ";
    public String defaultNewLine = System.getProperty("line.separator");
    public String defaultOptPrefix = "-";
    public String defaultLongOptPrefix = "--";
    public String defaultArgName = "arg";

    public void printHelp(String cmdLineSyntax, Options options) {
        this.printHelp(this.defaultWidth, cmdLineSyntax, null, options, null);
    }

    public void printHelp(String cmdLineSyntax, String header, Options options, String footer) {
        this.printHelp(this.defaultWidth, cmdLineSyntax, header, options, footer);
    }

    public void printHelp(int width, String cmdLineSyntax, String header, Options options, String footer) {
        PrintWriter pw = new PrintWriter(System.out);
        this.printHelp(pw, width, cmdLineSyntax, header, options, this.defaultLeftPad, this.defaultDescPad, footer);
        pw.flush();
    }

    public void printHelp(PrintWriter pw, int width, String cmdLineSyntax, String header, Options options, int leftPad, int descPad, String footer) throws IllegalArgumentException {
        if (cmdLineSyntax == null || cmdLineSyntax.length() == 0) {
            throw new IllegalArgumentException("cmdLineSyntax not provided");
        }
        this.printUsage(pw, width, cmdLineSyntax);
        if (header != null && header.trim().length() > 0) {
            this.printWrapped(pw, width, header);
        }
        this.printOptions(pw, width, options, leftPad, descPad);
        if (footer != null && footer.trim().length() > 0) {
            this.printWrapped(pw, width, footer);
        }
    }

    public void printUsage(PrintWriter pw, int width, String cmdLineSyntax) {
        int argPos = cmdLineSyntax.indexOf(32) + 1;
        this.printWrapped(pw, width, this.defaultSyntaxPrefix.length() + argPos, this.defaultSyntaxPrefix + cmdLineSyntax);
    }

    public void printOptions(PrintWriter pw, int width, Options options, int leftPad, int descPad) {
        StringBuffer sb = new StringBuffer();
        this.renderOptions(sb, width, options, leftPad, descPad);
        pw.println(sb.toString());
    }

    public void printWrapped(PrintWriter pw, int width, String text) {
        this.printWrapped(pw, width, 0, text);
    }

    public void printWrapped(PrintWriter pw, int width, int nextLineTabStop, String text) {
        StringBuffer sb = new StringBuffer(text.length());
        this.renderWrappedText(sb, width, nextLineTabStop, text);
        pw.println(sb.toString());
    }

    protected StringBuffer renderOptions(StringBuffer sb, int width, Options options, int leftPad, int descPad) {
        StringBuffer optBuf;
        Option option;
        String lpad = this.createPadding(leftPad);
        String dpad = this.createPadding(descPad);
        int max = 0;
        ArrayList<StringBuffer> prefixList = new ArrayList<StringBuffer>();
        Iterator i = options.getOptions().iterator();
        while (i.hasNext()) {
            option = (Option)i.next();
            optBuf = new StringBuffer(8);
            optBuf.append(lpad).append(this.defaultOptPrefix).append(option.getOpt());
            if (option.hasLongOpt()) {
                optBuf.append(',').append(this.defaultLongOptPrefix).append(option.getLongOpt());
            }
            if (option.hasArg()) {
                optBuf.append(' ').append(this.defaultArgName);
            }
            prefixList.add(optBuf);
            int n = max = optBuf.length() > max ? optBuf.length() : max;
        }
        i = prefixList.iterator();
        while (i.hasNext()) {
            optBuf = (StringBuffer)i.next();
            if (optBuf.length() < max) {
                optBuf.append(this.createPadding(max - optBuf.length()));
            }
            optBuf.append(dpad);
        }
        Collections.sort(prefixList, new StringBufferComparator());
        int nextLineTabStop = max + descPad;
        int optOffset = leftPad + this.defaultOptPrefix.length();
        Iterator i2 = prefixList.iterator();
        while (i2.hasNext()) {
            optBuf = (StringBuffer)i2.next();
            char opt = optBuf.charAt(optOffset);
            option = options.getOption(opt);
            this.renderWrappedText(sb, width, nextLineTabStop, optBuf.append(option.getDescription()).toString());
            if (!i2.hasNext()) continue;
            sb.append(this.defaultNewLine);
        }
        return sb;
    }

    protected StringBuffer renderWrappedText(StringBuffer sb, int width, int nextLineTabStop, String text) {
        int pos = this.findWrapPos(text, width, 0);
        if (pos == -1) {
            sb.append(this.rtrim(text));
            return sb;
        }
        sb.append(this.rtrim(text.substring(0, pos))).append(this.defaultNewLine);
        String padding = this.createPadding(nextLineTabStop);
        while (true) {
            if ((pos = this.findWrapPos(text = padding + text.substring(pos).trim(), width, nextLineTabStop)) == -1) {
                sb.append(text);
                return sb;
            }
            sb.append(this.rtrim(text.substring(0, pos))).append(this.defaultNewLine);
        }
    }

    protected int findWrapPos(String text, int width, int startPos) {
        char c;
        int pos = -1;
        pos = text.indexOf(10, startPos);
        if (pos != -1 && pos <= width || (pos = text.indexOf(9, startPos)) != -1 && pos <= width) {
            return pos;
        }
        if (startPos + width >= text.length()) {
            return -1;
        }
        pos = startPos + width;
        while (pos >= startPos && (c = text.charAt(pos)) != ' ' && c != '\n' && c != '\r') {
            --pos;
        }
        if (pos > startPos) {
            return pos;
        }
        pos = startPos + width;
        while (pos <= text.length() && (c = text.charAt(pos)) != ' ' && c != '\n' && c != '\r') {
            ++pos;
        }
        return pos == text.length() ? -1 : pos;
    }

    protected String createPadding(int len) {
        StringBuffer sb = new StringBuffer(len);
        int i = 0;
        while (i < len) {
            sb.append(' ');
            ++i;
        }
        return sb.toString();
    }

    protected String rtrim(String s) {
        if (s == null || s.length() == 0) {
            return s;
        }
        int pos = s.length();
        while (pos >= 0 && Character.isWhitespace(s.charAt(pos - 1))) {
            --pos;
        }
        return s.substring(0, pos);
    }

    private static class StringBufferComparator
    implements Comparator {
        public int compare(Object o1, Object o2) {
            return ((StringBuffer)o1).toString().compareTo(((StringBuffer)o2).toString());
        }

        StringBufferComparator() {
        }
    }
}

