/*
 * Decompiled with CFR 0.152.
 */
package cli1;

import cli1.HelpFormatter;
import junit.framework.Assert;
import junit.framework.TestCase;
import junit.framework.TestSuite;
import junit.textui.TestRunner;
import org.apache.commons.cli.Options;

public class TestHelpFormatter
extends TestCase {
    private static /* synthetic */ Class class$Lcli1$TestHelpFormatter;

    public static void main(String[] args) {
        String[] testName = new String[]{(class$Lcli1$TestHelpFormatter != null ? class$Lcli1$TestHelpFormatter : (class$Lcli1$TestHelpFormatter = TestHelpFormatter.class$("cli1.TestHelpFormatter"))).getName()};
        TestRunner.main((String[])testName);
    }

    public static TestSuite suite() {
        return new TestSuite(class$Lcli1$TestHelpFormatter != null ? class$Lcli1$TestHelpFormatter : (class$Lcli1$TestHelpFormatter = TestHelpFormatter.class$("cli1.TestHelpFormatter")));
    }

    public void testFindWrapPos() throws Exception {
        HelpFormatter hf = new HelpFormatter();
        String text = "This is a test.";
        Assert.assertEquals((String)"wrap position", (int)7, (int)hf.findWrapPos(text, 8, 0));
        Assert.assertEquals((String)"wrap position 2", (int)-1, (int)hf.findWrapPos(text, 8, 8));
        text = "aaaa aa";
        Assert.assertEquals((String)"wrap position 3", (int)4, (int)hf.findWrapPos(text, 3, 0));
    }

    public void testPrintWrapped() throws Exception {
        StringBuffer sb = new StringBuffer();
        HelpFormatter hf = new HelpFormatter();
        String text = "This is a test.";
        String expected = "This is a" + hf.defaultNewLine + "test.";
        hf.renderWrappedText(sb, 12, 0, text);
        Assert.assertEquals((String)"single line text", (Object)expected, (Object)sb.toString());
        sb.setLength(0);
        expected = "This is a" + hf.defaultNewLine + "    test.";
        hf.renderWrappedText(sb, 12, 4, text);
        Assert.assertEquals((String)"single line padded text", (Object)expected, (Object)sb.toString());
        expected = text = "aaaa aaaa aaaa" + hf.defaultNewLine + "aaaaaa" + hf.defaultNewLine + "aaaaa";
        sb.setLength(0);
        hf.renderWrappedText(sb, 16, 0, text);
        Assert.assertEquals((String)"multi line text", (Object)expected, (Object)sb.toString());
        expected = "aaaa aaaa aaaa" + hf.defaultNewLine + "    aaaaaa" + hf.defaultNewLine + "    aaaaa";
        sb.setLength(0);
        hf.renderWrappedText(sb, 16, 4, text);
        Assert.assertEquals((String)"multi-line padded text", (Object)expected, (Object)sb.toString());
    }

    public void testPrintOptions() throws Exception {
        StringBuffer sb = new StringBuffer();
        HelpFormatter hf = new HelpFormatter();
        boolean leftPad = true;
        int descPad = 3;
        String lpad = hf.createPadding(1);
        String dpad = hf.createPadding(3);
        Options options = null;
        String expected = null;
        options = new Options().addOption('a', false, "aaaa aaaa aaaa aaaa aaaa");
        expected = lpad + "-a" + dpad + "aaaa aaaa aaaa aaaa aaaa";
        hf.renderOptions(sb, 60, options, 1, 3);
        Assert.assertEquals((String)"simple non-wrapped option", (Object)expected, (Object)sb.toString());
        int nextLineTabStop = 4 + "-a".length();
        expected = lpad + "-a" + dpad + "aaaa aaaa aaaa" + hf.defaultNewLine + hf.createPadding(nextLineTabStop) + "aaaa aaaa";
        sb.setLength(0);
        hf.renderOptions(sb, nextLineTabStop + 17, options, 1, 3);
        Assert.assertEquals((String)"simple wrapped option", (Object)expected, (Object)sb.toString());
        options = new Options().addOption('a', "aaa", false, "dddd dddd dddd dddd");
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd dddd dddd";
        sb.setLength(0);
        hf.renderOptions(sb, 60, options, 1, 3);
        Assert.assertEquals((String)"long non-wrapped option", (Object)expected, (Object)sb.toString());
        nextLineTabStop = 4 + "-a,--aaa".length();
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd" + hf.defaultNewLine + hf.createPadding(nextLineTabStop) + "dddd dddd";
        sb.setLength(0);
        hf.renderOptions(sb, 25, options, 1, 3);
        Assert.assertEquals((String)"long wrapped option", (Object)expected, (Object)sb.toString());
        options = new Options().addOption('a', "aaa", false, "dddd dddd dddd dddd").addOption('b', false, "feeee eeee eeee eeee");
        expected = lpad + "-a,--aaa" + dpad + "dddd dddd" + hf.defaultNewLine + hf.createPadding(nextLineTabStop) + "dddd dddd" + hf.defaultNewLine + lpad + "-b      " + dpad + "feeee eeee" + hf.defaultNewLine + hf.createPadding(nextLineTabStop) + "eeee eeee";
        sb.setLength(0);
        hf.renderOptions(sb, 25, options, 1, 3);
        Assert.assertEquals((String)"multiple wrapped options", (Object)expected, (Object)sb.toString());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    public TestHelpFormatter(String s) {
        super(s);
    }
}

