/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.commons.simplestore;

/**
 *
 * @author Juozas Baliuka <a href="mailto:baliuka@mwm.lt">
 *      baliuka@mwm.lt</a>
 * @version $Id: Reachable.java,v 1.1 2002/01/27 17:04:17 froehlich Exp $
 */
public interface Reachable {
    /** Must save strong refense on parameter,
     * This interface is used for  values then Store is used with
     * Swap.
     * Sample impl :
     * class MyValueObject implements Reachable{
     *   Object reference;
     *   Object value;
     *   public MyValueObject( Object value){
     *          this.value = value;
     *    }
     *   public void setReference(Object reference) {
     *          this.reference = reference;
     *     }
     *   public Object getValue(){
     *          return value;
     *    }
     * }
     *
     * @param object value object must save strong refernce on parameter.
     */    
   public void setReference(Object object);
   
}

