/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.commons.simplestore;

/**
 * Interface for the Store implementations
 *
 * @author Gerhard Froehlich <a href="mailto:g-froehlich@gmx.de">
 *      g-froehlich@gmx.de</a>
 * @version $Id: Store.java,v 1.10 2002/01/21 22:02:36 froehlich Exp $
 */
public interface Store {
    Store getNextStore();
    
    void free();
    
    void clear();
    
    Object get(Object key);
    
    boolean isEmpty();
    
    void put(Object key, Object value);
    
    Object remove(Object key);
    
    //put (Map m); //?
    
    boolean containsKey(Object key);
    
    int size();
}

