/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.commons.simplestore;

import java.util.Set;
import java.util.Collection;
import java.util.Map;
import java.io.IOException;

/**
 *
 * @author Juozas Baliuka <a href="mailto:baliuka@mwm.lt">
 *      baliuka@mwm.lt</a>
 * @author Gerhard Froehlich <a href="mailto:g-froehlich@gmx.de">
 *      g-froehlich@gmx.de</a>
 * @version $Id: SynchronizedStore.java,v 1.4 2002/01/21 22:02:36 froehlich Exp $
 */
final class SynchronizedStore 
implements Store {
    
    private Store store;
    
    /** Creates new SynchronizedStore */
    public SynchronizedStore(Store store) {
        if(store == null) {
            throw new NullPointerException();
        }
        this.store = store;
    }
    
    /**
     * Remove the object associated to the given key.
     *
     * @param key the Key Object
     */
    public Object remove(Object key) {
        synchronized(store) {
            return store.remove(key);
        }    
    }
    
    /**
     * Indicates if the given key is associated to a contained object.
     *
     * @param key the Key Object
     */
    public boolean containsKey(Object key) {
        synchronized(store) {
          return store.containsKey(key);
        }
    }
    
    /**
     * Frees some object out of the Store.
     */
    public void free() {
        synchronized(store) {
           store.free();
        }
    }
    
    public void put(Object key, Object value) {
        synchronized(store) {
            store.put(key,value);
        }
    }
    
    /**
     * Get the object associated to the given unique key.
     *
     * @param key the Key Object
     */
    public Object get(Object key) {
        synchronized(store) {
          return store.get(key);
        }
    }
    
    public boolean isEmpty()  {
        synchronized(store) {
            return store.isEmpty(); 
        }    
    }
    
    public int size()  {
        synchronized(store) {
            return store.size(); 
        }    
    }
    
    public void clear()  {
        synchronized(store) {
            store.clear(); 
        }    
    }
    
    public Store getNextStore() {
        synchronized(store) {
            return store.getNextStore(); 
        }            
    }
}
