/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.commons.simplestore.cleanup;

import org.apache.commons.simplestore.Store;

import java.util.Iterator;

/**
 * Interface for the StoreJanitors
 *
 * @author Gerhard Froehlich <a href="mailto:g-froehlich@gmx.de">
 *      g-froehlich@gmx.de</a>
 * @version $Id: StoreJanitor.java,v 1.2 2002/01/20 12:24:50 froehlich Exp $
 */
public interface StoreJanitor {

    /** 
     * register method for the stores
     * 
     * @param store the Store to be registered
     */
    void register(Store store);

    /** 
     * unregister method for the stores 
     *
     * @param store the Store to be unregistered
     */
    void unregister(Store store);
    
    /** 
     * get an iterator to list registered stores 
     */
    Iterator iterator();
}
