/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.commons.simplestore.jdbc;

import org.apache.commons.simplestore.persistence.*;
import org.apache.commons.simplestore.*;


// TODO Synchronization
/**
 *
 * @author Juozas Baliuka <a href="mailto:baliuka@mwm.lt">
 *      baliuka@mwm.lt</a>
 * @version $Id$
 */
public class DBStorage extends AbstractStorage{
    
    private static final boolean DEBUG = true;
    
    private static final String CONNECTION = "org.apache.commons.simplestore.jdbc.DBStorage.connection";
    
    private Store store = null;
    
    //    private java.sql.Connection connection = null ;
    private javax.sql.DataSource ds;
    
    interface ResutSetHandler {
        
        public void nextResult(int index,String name,Object value ,int type);
        
        
    }
    
    
    /** Creates new DBStorageManager */
    public DBStorage(javax.sql.DataSource ds) {
        this.ds = ds;
    }
    
    protected void createObject(  MetaObject properties ) throws StorageException{
        
        final java.sql.Connection connection = getConnection();
        final Class clasz = properties.getPersistentClass();
        final Object id = properties.getOID();
        final java.lang.reflect.Method methods[] = clasz.getMethods();
        final java.util.Map map = properties.getProperties();
        final java.util.List values = new java.util.ArrayList( methods.length/2 + 1 );
        String names  = "";
        String params  = "";
        values.add(id);
        
        for( int i = 0; i < methods.length; i++ ){
            
            String name = methods[i].getName();
            if( name.startsWith("set")){
                name = name.substring( 3 );
                Object value = toSQLType(map.get(name));
                if( value == null )continue;
                names += "," + toSQLName(name);
                values.add(value);
                params += ",?";
            }
            
        }
        
        
        final String sql = "INSERT INTO " + toSQLName(clasz.getName()) + "(ID" + names + ")VALUES(?" + params + ")" ;
        
        excecute(connection,sql,values.toArray(),null);
        
    }
    // TODO must be converter interface
    public static Object convertNumber(Number number,Class cls){
        
        if(cls.equals(Byte.class))
            return new Byte(number.byteValue());
        else if( cls.equals(Short.class) )
            return new Short(number.shortValue());
        else if(cls.equals(Integer.class))
            return new Integer(number.intValue());
        else if( cls.equals( Long.class ) )
            return new Long(number.longValue());
        else if( cls.equals( Float.class ) )
            return new Float(number.floatValue());
        else if( cls.equals( Double.class ) )
            return new Double(number.doubleValue());
        else if( cls.equals( Boolean.class ) )
            return new Boolean( number.intValue() != 0  );
        else if( cls.equals( Character.TYPE ) )
            return new Character( number.toString().charAt(0)  );
        else
            throw new java.lang.UnsupportedOperationException( "Number class = " + number.getClass().getName() + " Target Class " + cls.getName());
        
    }
    // TODO must be converter interface
    public static Object convertPrimityve(Number number,Class cls){
        
        if(cls.equals(Byte.TYPE))
            return new Byte(number.byteValue());
        else if (cls.equals(Short.TYPE))
            return new Short( number.shortValue());
        else if(cls.equals(Integer.TYPE))
            return new Integer(number.intValue());
        else if ( cls.equals( Long.TYPE ) )
            return new Long(number.longValue());
        else if ( cls.equals( Float.TYPE ) )
            return new Float(number.floatValue());
        else if ( cls.equals( Double.TYPE ) )
            return new Double(number.doubleValue());
        else if ( cls.equals( Boolean.TYPE ) )
            return new Boolean( number.intValue() != 0  );
        else if ( cls.equals( Character.TYPE ) )
            return new Character( number.toString().charAt(0)  );
        else
            throw new java.lang.UnsupportedOperationException( "Number class = " + number.getClass().getName() + " Target Class " + cls.getName());
        
    }
    // TODO must be converter interface
    public static Object convert(Object object,Class cls){
        try{
            if( cls.isPrimitive() ){
                if( object == null ){
                    return cls.newInstance();
                }
                if( object instanceof Number ){
                    return convertPrimityve((Number)object,cls);
                }
                
            }
            
            if(object == null){
                return null;
            }
            
            if( cls.isAssignableFrom(object.getClass())  ){
                return object;
            }
            
            if( object instanceof String ){
                return org.apache.commons.beanutils.ConvertUtils.convert((String)object,cls);
            }
            
            
            if( cls.isAssignableFrom(Number.class ) && object instanceof Number ){
                return convertNumber((Number)object,cls);
            }
            
            if( cls.equals( Boolean.class ) && object instanceof Number ){
                return new Boolean((( Number )object).intValue() != 0  );
            }
            
            if( cls.equals( Character.TYPE ) ){
                return new Character( object.toString().charAt(0)  );
            }
            
            throw new java.lang.UnsupportedOperationException( cls.getName() + ":" + object );
            
        }catch(Throwable t){
            // TODO
            t.printStackTrace();
            throw new RuntimeException( t.getClass().getName() + ":" + t.getMessage() );
        }
    }
    
    // TODO must be converter interface
    public static Object toSQLType(Object object){
        
        if(object == null)
            return null;
        if( object instanceof Boolean ){
            boolean value = ((Boolean)object).booleanValue();
            return (  value ? new Short((short)1) :  new Short((short)0)  );
        }
        if( object instanceof java.util.Date && !(object instanceof java.sql.Date) ){
            return new java.sql.Date(((java.util.Date)object).getTime());
        }
        
        return object;
    }
    
    
    public Class getReturnType( Class clasz,String name )throws java.lang.Throwable{
        
        return clasz.getMethod(name,null).getReturnType();
        
    }
    
    public Object retrieveObject(final Class clasz, Object id) throws StorageException {
        
        final InternalTransaction transaction = getTransaction();
        Persistent result = (Persistent)store.get(id);
        if( result != null ){
            transaction.add(result.getMetaObject());
            return result;
        }
        
        final java.sql.Connection connection = getConnection();
        final String sql = "SELECT * FROM " + toSQLName(clasz.getName()) + " WHERE ID=?";
        result = (Persistent)PersistentProxy.getPersitent(clasz,id,false,this);
        final MetaObject pc = result.getMetaObject();
        final java.util.Map map = pc.getProperties();
        
        transaction.add(pc);
        store.put(id,result);
        
        
        excecute(connection,sql,new Object[]{id},
        
        new ResutSetHandler(){
            
            public void nextResult( int index,String name,Object value , int type ){
                try{
                    if(value != null ){
                        String property = toPropertyName(name);
                        if( property.equals("Id") )
                            return;
                        map.put(property , convert(value,getReturnType(clasz,"get" + property)) );
                    }
                }catch(java.lang.Throwable t){
                    t.printStackTrace();
                    throw new java.lang.RuntimeException(t.getClass().getName() + ":" + t.getMessage());
                }
            }
            
        }
        
        );
        
        return result;
    }
    
    public java.util.Set retrieveAll(final Class clasz) throws StorageException{
        
        final java.sql.Connection connection = getConnection();
        final  String sql = "SELECT ID AS INTERNAL_OID, * FROM " +  toSQLName( clasz.getName() );
        final java.util.Set objects = new java.util.HashSet();
        final InternalTransaction transaction = getTransaction();
        
        
        excecute(connection,sql,null,
        
        new ResutSetHandler(){
            java.util.Map map;
            
            public void nextResult( int index,String name,Object value , int type ){
                try{
                    if( index == 1 ){
                        
                        MetaObject pc = ((Persistent)
                        PersistentProxy.getPersitent(clasz,value,false,DBStorage.this)).getMetaObject();
                        map = pc.getProperties();
                        // TODO must be optimized !!!
                        if( null != store.get(pc.getOID()) )
                            objects.add(pc);
                        transaction.add(pc);
                        
                    }
                    String property = toPropertyName(name);
                    if( property.equals("Id") )
                        return;
                    map.put(property , convert(value,getReturnType(clasz,"get" + property)) );
                    
                }catch( java.lang.Throwable t ){
                    //TODO
                    t.printStackTrace();
                    throw new java.lang.RuntimeException(t.getClass().getName() + ":" + t.getMessage());
                }
            }
        }
        
        );
        return objects;
    }
    
    public java.util.Set query(final Class clasz, String procName, Object[] args) throws StorageException{
        
        final java.sql.Connection connection = getConnection();
        final java.util.Set objects = new java.util.HashSet();
        final InternalTransaction transaction = getTransaction();
        
        // TODO map proc names to query
        excecute(connection,procName,args,
        
        new ResutSetHandler(){
            java.util.Map map;
            public void begin(int i){}
            
            public Object end(int i){ return null; }
            
            public void nextResult( int index,String name,Object value , int type ){
                try{
                    if(index == 1){
                        MetaObject pc = ((Persistent)
                        PersistentProxy.getPersitent(clasz,value,false,DBStorage.this)).getMetaObject();
                        map = pc.getProperties();
                        // TODO must be optimized !!!
                        if( null != store.get(pc.getOID()) )
                            objects.add(pc);
                        
                        transaction.add(pc);
                        
                    }
                    String property = toPropertyName(name);
                    if( property.equals("Id") )
                        return;
                    map.put(property , convert(value,getReturnType(clasz,"get" + property)) );
                }catch( java.lang.Throwable t ){
                    t.printStackTrace();
                    throw new java.lang.RuntimeException(t.getClass().getName() + ":" + t.getMessage());
                    
                }
            }
        }
        
        );
        return objects;
    }
    
    // TODO must be mapping interface
    
    public  static String toSQLName(String clName){
        
        String result = clName.substring(clName.lastIndexOf('.') + 1, clName.length() );
        StringBuffer sb = new StringBuffer();
        char cbuff [] = result.toCharArray();
        
        for(int i = 0; i < cbuff.length; i++ ){
            
            if( Character.isUpperCase( cbuff[i] )){
                if( i != 0 ){
                    sb.append( "_" + cbuff[i] );
                }else sb.append(  cbuff[i] );
                
            }else{
                
                sb.append( Character.toUpperCase(cbuff[i]) );
            }
            
        }
        
        return sb.toString();
        
    }
    
    // TODO must be mapping interface
    public   static String toPropertyName(String tblName){
        
        
        final String result = tblName;
        final StringBuffer sb = new StringBuffer();
        final char cbuff [] = result.toCharArray();
        
        for( int i = 0; i < cbuff.length; i++ ){
            
            if( cbuff[i] == '_' ){
                
                sb.append( Character.toUpperCase(cbuff[ ++i ]) );
                
            }else{
                if( i == 0 )
                    sb.append( Character.toUpperCase(cbuff[i]) );
                else sb.append( Character.toLowerCase(cbuff[i]) );
            }
            
        }
        
        return sb.toString();
        
        
    }
    
    protected void removeObject( MetaObject obj )throws StorageException{
        
        final java.sql.Connection connection = getConnection();
        final String name = toSQLName(obj.getPersistentClass().getName());
        final Object id   = obj.getOID();
        final String sql  = "DELTE FROM " + name +" WHERE ID=?";
        
        excecute(connection,sql, new Object[]{id}, null );
    }
    
    
    public void storeObject(MetaObject properties) throws StorageException {
        
        final java.sql.Connection connection = getConnection();
        final Class clasz = properties.getPersistentClass();
        final String name = toSQLName(clasz.getName());
        
        try{
            
            final java.lang.reflect.Method methods[] = clasz.getMethods();
            final java.util.List values = new java.util.ArrayList( methods.length/2 + 1 );
            final java.util.Map map = properties.getProperties();
            final StringBuffer names = new StringBuffer(methods.length*10);
            
            for( int i = 0; i < methods.length; i++ ){
                
                String mName = methods[i].getName();
                if( mName.startsWith("set")){
                    mName = mName.substring(3);
                    Object value = toSQLType(map.get( mName ));
                    names.append(toSQLName( mName ));
                    names.append("=?,");
                    values.add( value );
                    
                }
                
            }
            names.setCharAt(names.length() - 1,' ');
            names.append("WHERE ID=?");
            values.add(properties.getOID());
            
            final String sql = "UPDATE " + name + " SET " + names;
            
            excecute(connection,sql,values.toArray(),null);
            
        }catch(Exception se ){
            se.printStackTrace();
            throw new RuntimeException(se.getMessage());
        }
        
    }
    
    protected void internalCommit() throws StorageException {
        try{
            
            java.sql.Connection connection = getConnection();
            
            try{
                
                connection.commit();
                
            }finally{
                
                connection.close();
                
            }
        }catch( java.sql.SQLException se){
            throw new StorageException(se.getMessage() ,se);
            
        }
    }
    
    protected void internalRollback() throws StorageException {
        
        try{
            
            java.sql.Connection connection = getConnection();
            
            try{
                
                connection.rollback();
                
            }finally{
                
                connection.close();
                
            }
        }catch( java.sql.SQLException se){
            
            throw new StorageException(se.getMessage() ,se);
            
        }
    }
    
    protected void internalBegin() throws StorageException {
        
        try{
            
            java.sql.Connection  connection = ds.getConnection();
            getTransaction().setAttribute(CONNECTION,connection);
            
        }catch( java.sql.SQLException se){
            
            throw new StorageException(se.getMessage() ,se);
            
        }
    }
    
    static public Integer excecute(java.sql.Connection connection,String sql,Object[] args,ResutSetHandler eh )throws StorageException{
        
        try{
            
            final java.sql.PreparedStatement statement = connection.prepareStatement(sql);
            java.sql.ResultSet rs = null;
            if( DEBUG ){
                System.out.println(sql);
            }
            try{
                if(args != null){
                    
                    
                    for(int i = 1 ; i <= args.length; i++ ){
                        
                        if(args[ i - 1 ] == null ){
                            statement.setNull(i , java.sql.Types.OTHER);
                        }else{
                            statement.setObject(i,args[i - 1]);
                        }
                    }
                }
                if( statement.execute()){
                    rs = statement.getResultSet();
                }else{
                    int updates = statement.getUpdateCount();
                    if(updates > 0)
                        return new Integer(updates);
                    else return null;
                }
                
                do{
                    if(rs != null && eh != null){
                        
                        java.sql.ResultSetMetaData rsmd = rs.getMetaData();
                        int cnt = rsmd.getColumnCount();
                        
                        
                        while(rs.next()){
                            for(int i = 1; i <= cnt; i++  ){
                                String name = rsmd.getColumnName(i);
                                Object val = rs.getObject(i);
                                eh.nextResult(i,name,val,rsmd.getColumnType(i));
                            }
                        }
                        
                    }
                    if(statement.getMoreResults())
                        rs = statement.getResultSet();
                    else break;
                }while(rs != null);
                
            }finally{
                
                if( rs != null)
                    rs.close();
                if(statement != null)
                    statement.close();
                
            }
        }catch( java.sql.SQLException se ){
            throw  new StorageException(sql,se);
        }
        return null;
    }
    
    public void close() {
        
        try{
            
            java.sql.Connection connection = (java.sql.Connection)getTransaction().getAttribute(CONNECTION);
            if(connection != null )
                connection.close();
        }catch( Exception e){
            
            e.printStackTrace();
            // TODO
        }
    }
    
    public void setContext(Store store) {
        this.store = store;
    }
    
    private java.sql.Connection getConnection(){
        
        java.sql.Connection connection = (java.sql.Connection)getTransaction().getAttribute(CONNECTION);
        if( connection == null )
            throw new java.lang.IllegalStateException("Transaction not Started");
        return connection;
        
    }
}
