/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.commons.simplestore.persistence;

import com.mw.persist.*;

/**
 *
 * @author Juozas Baliuka <a href="mailto:baliuka@mwm.lt">
 *      baliuka@mwm.lt</a>
 * @version $Id$
 */

public abstract class AbstractStorage implements Storage, InternalTransaction, TransactionManager{
    
    java.util.Map attributes = new java.util.HashMap();
    
    protected abstract void createObject(  MetaObject properties )throws StorageException;
    protected abstract void removeObject(  MetaObject properties )throws StorageException;
    protected abstract void internalCommit()throws StorageException;
    protected abstract void internalRollback()throws StorageException;
    protected abstract void internalBegin()throws StorageException;
    
    
    
    
    public InternalTransaction getTransaction() {
        
        return TransactionImpl.getInstance(this);
        
    }
    
    
    public void begin(java.util.Set objects) {
        try{
            internalBegin();
        }catch(java.lang.Throwable t){
            // TODO
            t.printStackTrace();
            throw new RuntimeException(t.getClass() + ":" + t.getMessage());
        }
    }
    
    public void add(MetaObject props) {
        ((InternalTransaction)getTransaction()).add(props);
    }
    
    public void commit() {
        try{
            getTransaction().commit();
            internalCommit();
        }catch(java.lang.Throwable t){
            // TODO
            t.printStackTrace();
            throw new RuntimeException(t.getClass() + ":" + t.getMessage());
        }
    }
    
    public void begin() {
        try{
            getTransaction().begin();
            internalBegin();
        }catch(java.lang.Throwable t){
            // TODO
            throw new RuntimeException(t.getClass() + ":" + t.getMessage());
        }
    }
    
    public void rollback(java.util.Set objects) {
        try{
            //TODO implement roolback
            internalRollback();
            objects.clear();
        }catch(java.lang.Throwable t){
            throw new RuntimeException(t.getClass() + ":" + t.getMessage());
        }
    }
    
    public void rollback() {
        
        try{
            getTransaction().rollback();
            internalRollback();
        }catch(java.lang.Throwable t){
            // TODO
            throw new RuntimeException(t.getClass() + ":" + t.getMessage());
        }
        
    }
    
    public void commit(java.util.Set objects) {
        
        
        try{
            java.util.Iterator iterator = objects.iterator();
            while(iterator.hasNext()){
                
                MetaObject pp = (MetaObject)iterator.next();
                if( pp.isNew() ){
                    createObject(pp);
                    
                }
                if( pp.isDirty() && ! pp.isNew() ){
                    storeObject(pp);
                    
                }
                if( pp.isDeleted() ){
                    
                    removeObject(pp);
                }
                pp.setDirty(false);
            }
            objects.clear();
            internalCommit();
        }catch( Throwable t ){
            // TODO
            t.printStackTrace();
            throw new java.lang.RuntimeException("Error");
        }
        
    }
    public Object getAttribute(String name) {
        return attributes.get(name);
    }
    
    public void removeAttribute(String name) {
        attributes.remove(name);
    }
    
    public void setAttribute(String name, Object value) {
        
        attributes.put(name,value);
    }
}
