/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.commons.simplestore.persistence;

import org.apache.commons.simplestore.*;

/**
 *
 * @author Juozas Baliuka <a href="mailto:baliuka@mwm.lt">
 *      baliuka@mwm.lt</a>
 * @version $Id$
 */

public class PersistenceManager {
  
    private static PersistenceManager pm;
    
    private Storage storage;
    private TransactionManager transactionManager;
    private Store store = SoftRefMemoryStore.getInstance( new java.util.HashMap(), null , 0xFF );
    
    /** Creates new PersiatenceManager */
    protected  PersistenceManager( Storage storage, TransactionManager transactionManager ) {
        this.storage = storage;
        this.transactionManager = transactionManager;
        
    }
    
    static public PersistenceManager getPersistenceManager( Storage storage,TransactionManager transactions ){
        if( pm == null ){
            pm = new PersistenceManager( storage,transactions );
            storage.setContext(pm.store);
        }  
        return pm;
        
    }
    
    public Transaction getTransaction(){
    
        return transactionManager.getTransaction();
    
    }
    
    public Object createInstance( Class aclass ){
        
        Object id = generateOID(aclass);
        Persistent p = PersistentProxy.getPersitent(aclass,id,true,transactionManager);
        
        return p;
        
    }
    
    public Object findInstance( Class clasz,Object oid )throws StorageException{
    
         return storage.retrieveObject(clasz, oid );
        
    }
   public java.util.Set findAll( Class clasz )throws StorageException{
   
       return storage.retrieveAll( clasz );
   }
    
    public void removeInstance(Object pc){
        
        MetaObject p = ((Persistent)pc).getMetaObject();
        if( p != null )
            p.remove();
        
    }
   public Object getOID( Object pc ){
        
        return ((Persistent)pc).getOID();
        
        
    }
    
    private static java.security.SecureRandom seeder = new java.security.SecureRandom();
    
    private synchronized Object  generateOID( Class aclass ){
      
   //TODO ADD interface OIDGenerator  
        
        byte[] bytes = new byte[8];
        int value = seeder.nextInt();
        int i = 0;
        
        bytes[i++] = (byte) ((value >>> 24) & 0xFF);
        bytes[i++] = (byte) ((value >>> 16) & 0xFF);
        bytes[i++] = (byte) ((value >>> 8) & 0xFF);
        bytes[i++] = (byte) (value & 0xFF);
       
        value = (int) System.currentTimeMillis() & 0xFFFFFFFF; 
       
        bytes[i++] = (byte) ((value >>> 24) & 0xFF);
        bytes[i++] = (byte) ((value >>> 16) & 0xFF);
        bytes[i++] = (byte) ((value >>> 8) & 0xFF);
        bytes[i++] = (byte) (value & 0xFF);
        
      return new Long( new java.math.BigInteger(bytes).longValue());
      
    }
}
