/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.commons.simplestore.persistence;

import java.lang.reflect.*;

/**
 *
 * @author Juozas Baliuka <a href="mailto:baliuka@mwm.lt">
 *      baliuka@mwm.lt</a>
 * @version $Id$
 */
public class PersistentProxy implements MetaObject, InvocationHandler, java.io.Serializable {
    
    
    static Method HASH_CODE;
    static Method EQUALS;
    static Method TO_STRING;
    static Method GET_OID;
    static Method GET_META_OBJECT;
    
    static{
        
        try{
            
            GET_OID         = Persistent.class.getMethod("getOID",null);
            GET_META_OBJECT = Persistent.class.getMethod("getMetaObject",null);
            
            
            HASH_CODE       = Object.class.getMethod("hashCode",null);
            TO_STRING       = Object.class.getMethod("toString",null);
            EQUALS          = Object.class.getMethod("equals",new Class[]{Object.class});
            
        }catch(Exception e){
            e.printStackTrace();
            throw new Error(e.getMessage());
            
        }
        
    }
    
    java.util.Map map = new java.util.Hashtable();
    
    Object  oid  = null;
    Class pClass;
    TransactionManager transactionManager;
    boolean dirty   = false;
    boolean deleted = false;
    boolean newCreated ;
    
    /** Creates new ValueProxy */
    public PersistentProxy(Class pClass,Object oid, boolean newCreated, TransactionManager transactionManager) {
        
        this.oid = oid;
        this.newCreated = newCreated;
        this.transactionManager = transactionManager;
        this.pClass  = pClass;
        
    }
    
    public java.lang.Object handleEquals(java.lang.Object obj ){
        
        if( obj == null   ){
            return new Boolean(false);
        }
        
        if(! (obj instanceof Persistent ) ){
            return new Boolean(false);
        }
        
        Persistent object = (Persistent)obj;
        
        
        if( oid == null ){
            
            return new Boolean( oid == object.getOID() );
            
        }else{
            
            return new Boolean( oid.equals( object.getOID() ) );
        }
        
        
    }
    
    public java.lang.Object invoke(Object obj, Method method, Object[] obj2) throws java.lang.Throwable {
        
        synchronized( this ){
            
            if ( GET_META_OBJECT.equals( method) ){
                return this;
                
            }else if( TO_STRING.equals( method ) ){
                
                return oid;
                
            }else if( GET_OID.equals( method ) ){
                
                return oid;
                
            }else if ( HASH_CODE.equals( method ) ){
                
                if(oid == null){
                    return new Integer(0);
                }
                return new Integer(oid.hashCode());
                
            }else if( EQUALS.equals(method) ){
                
                return handleEquals(obj2[0]);
                
                
            } else{
                
                return  handleProperty(obj,method,obj2);
                
            }
            
        }
    }
    
    
    public java.lang.Object handleProperty(java.lang.Object obj, java.lang.reflect.Method method, java.lang.Object[] obj2) throws java.lang.Throwable {
        
        String name = method.getName();
        
        
        if( name.startsWith("set")){
            
            setProperty(name.substring(3), obj2[0] );
            return null;
            
        }else if( name.startsWith("get") || name.startsWith("is")  ){
            
            if(method.getName().startsWith("get"))
                name = method.getName().substring(3);
            else name = method.getName().substring(2);
            
            return getProperty(name);
            
        }
        
        throw new java.lang.IllegalStateException("pure method " + method.getName());
        
        
    }
    
    
    public static Persistent getPersitent(Class persistent,Object oid,boolean newCreated, TransactionManager transactionManager){
        
        Persistent p =  (Persistent)Proxy.newProxyInstance(
        ClassLoader.getSystemClassLoader(),new Class[]{persistent,Persistent.class},
        new PersistentProxy(persistent,oid,newCreated, transactionManager));
        
        if( newCreated ) {
            
            MetaObject mo = p.getMetaObject();
            transactionManager.getTransaction().add(mo);
        }
        return p;
        
    }
    
    
    public boolean isDeleted() {
        return deleted;
    }
    
    public boolean isNew() {
        return newCreated;
    }
    
    public MetaObject getMetaObject() {
        return this;
    }
    
    public void setProperty( String name, Object value ) {
        
        Object old = map.put(name,value);
        if( old == null || !old.equals(value )){
            dirty = true;
            transactionManager.getTransaction().add( this );
        }
        
    }
    
    public java.util.Map getProperties() {
        return map;
    }
    
    public Object getProperty(String name) {
        return  map.get(name);
        
    }
    
    public boolean isLoaded() {
        return true;
    }
    
    public void remove() {
        deleted = true;
    }
    
    public Class getPersistentClass() {
        return pClass;
    }
    
    public Object getOID() {
        return oid;
    }
    
    public boolean isDirty() {
        return dirty;
    }
    
    public void setDirty(boolean dirty) {
        this.dirty = dirty;
        this.newCreated = false;
    }
    
}
