/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.commons.simplestore.persistence;

/**
 *
 * @author Juozas Baliuka <a href="mailto:baliuka@mwm.lt">
 *      baliuka@mwm.lt</a>
 * @version $Id$
 */
public class StorageException extends java.lang.Exception {

    public Throwable detail;
    /**
     * Creates new <code>StorageException</code> without detail message.
     */
    public StorageException() {
    }


    /**
     * Constructs an <code>StorageException</code> with the specified detail message.
     * @param msg the detail message.
     * @param detail the detail Throwable.
     */
    public StorageException(String msg,Throwable detail ) {
        super(msg);
        this.detail = detail;
    }
    
    public java.lang.String getMessage() {
        
        return super.getMessage() + ( detail == null ? "" : " : " +  detail.getMessage()  ) ;
        
    }    
    
    
    
}


