/*****************************************************************************
 * Copyright (C) The Apache Software Foundation. All rights reserved.        *
 * ------------------------------------------------------------------------- *
 * This software is published under the terms of the Apache Software License *
 * version 1.1, a copy of which has been included  with this distribution in *
 * the LICENSE file.                                                         *
 *****************************************************************************/

package org.apache.commons.simplestore.persistence;

import org.apache.commons.simplestore.*;
/**
 *
 * @author Juozas Baliuka <a href="mailto:baliuka@mwm.lt">
 *      baliuka@mwm.lt</a>
 * @version $Id$
 */

public class TransactionImpl implements InternalTransaction{
    
    static private Store instances = SoftRefMemoryStore.getInstance( new java.util.HashMap(), null , 0x00 );    
    
   
    int threadId = getCurrentThreadId();
    InternalTransaction transaction;
    java.util.Set objects;
    java.util.Map attributes = new java.util.HashMap();
    boolean complete = true;
    
    /** Creates new TransactionImpl */
    public TransactionImpl( InternalTransaction transaction, java.util.Set objects) {
        this.objects = objects;
        this.transaction = transaction;
 
    }
    
    private static int getCurrentThreadId(){
        return System.identityHashCode( Thread.currentThread() );
    }
    
    public static InternalTransaction getInstance(InternalTransaction transaction){
        
        Number threadId = new Integer(getCurrentThreadId());
        InternalTransaction tr = (InternalTransaction) instances.get(threadId);
        if( tr != null )return tr;
        
        tr = new TransactionImpl(transaction,new java.util.HashSet());
        instances.put(threadId,tr);
        
        return tr;
        
        
    }
    
    public void commit() {
        checkState();
        checkState(!complete);
        transaction.commit(objects);
        complete = true;
        
    }
    
    public void begin() {
        checkState();
        checkState( complete );
        transaction.begin( objects );
        complete = false;
    }
    
    public void rollback() {
        checkState();
        checkState( !complete );
        transaction.rollback( objects );
        complete = true;
    }
    
    public int  getThreadId(){
        
        return threadId;
        
    }
    
    void checkState( boolean b ){
        if( !b  )
            throw new  java.lang.IllegalStateException("Illegal Transaction state");
    }
    void checkState(){
        int id = getCurrentThreadId();
        if( threadId != id )
            throw new  java.lang.IllegalStateException("Accessed Transaction " + threadId + " in " + id);
    }
    
    public void add(MetaObject props) {
        checkState();
        objects.add(props);
        
    }
    
    public void begin(java.util.Set objects) {
        transaction.begin(objects);
    }
    
    public void rollback(java.util.Set objects) {
        transaction.rollback(objects);
    }
    
    public void commit(java.util.Set objects) {
        transaction.commit(objects);
    }
    
    public Object getAttribute(String name) {
        return attributes.get(name);
    }    
    
    public void removeAttribute(String name) {
        attributes.remove(name);
    }    
    
    public void setAttribute(String name, Object value) {
        
        attributes.put(name,value);
    }
    
}
