package de.nitwit.commons.collections;

import java.util.Map;

import org.apache.commons.functor.adapter.IgnoreLeftFunction;
import org.apache.commons.functor.core.Constant;
import org.apache.commons.functor.core.Identity;
import org.apache.commons.functor.core.IsNull;
import org.apache.commons.functor.core.composite.Conditional;

/**
 * @author Timo Nentwig
 */
public class DefaultValueFunctorMap extends FunctorMap
{

	private Object defaultValue;

	/**
	 * Factory method to create a default value map.
	 * 
	 * @param map
	 *            the map to decorate, must not be null
	 * @throws IllegalArgumentException
	 *             if map is null
	 */
	public static Map decorate( final Map map, final Object defaultValue )
	{
		return new DefaultValueFunctorMap( map, defaultValue );
	}

	protected DefaultValueFunctorMap( final Map map, final Object defaultValue )
	{
		super( map );
		setOnGet( IgnoreLeftFunction.adapt( Conditional.function( IsNull.instance(), new Constant( defaultValue ), Identity.instance() ) ) );
	}

}