package de.nitwit.commons.collections;

import java.util.Map;

import org.apache.commons.collections.map.AbstractMapDecorator;
import org.apache.commons.functor.BinaryFunction;
import org.apache.commons.functor.core.RightIdentity;

/**
 * Functor Map. Glue between commons collections and commons functor.
 * 
 * @author Timo Nentwig
 */
public class FunctorMap extends AbstractMapDecorator
{

	private BinaryFunction onGet = RightIdentity.instance();

	private BinaryFunction onPut = RightIdentity.instance();

	/**
	 * Factory method to create a functor map.
	 * 
	 * @param map
	 *            the map to decorate, must not be null
	 * @throws IllegalArgumentException
	 *             if map is null
	 */
	public static Map decorate( Map map )
	{
		return new FunctorMap( map );
	}

	/**
	 * Constructor that wraps (not copies).
	 * 
	 * @param map
	 *            the map to decorate, must not be null
	 * @throws IllegalArgumentException
	 *             if map is null
	 */
	protected FunctorMap( Map map )
	{
		super( map );
	}

	public Object get( Object key )
	{
		return onGet.evaluate( key, super.get( key ) );
	}

	public Object put( Object key, Object value )
	{
		final Object old = super.get( key );
		super.put( key, onPut.evaluate( old, value ) );
		return onGet.evaluate( key, old );
	}

	protected void setOnGet( BinaryFunction function )
	{
		this.onGet = function;
	}

	protected void setOnPut( BinaryFunction function )
	{
		this.onPut = function;
	}

	// protected void setOnClear(UnaryProcedure procedure) {
	// this.onClear = procedure;
	// }
	//
	// protected void setOnPutAll(BinaryProcedure procedure) {
	// this.onPutall = procedure;
	// }
	//
	// protected void setOnRemove(BinaryFunction function) {
	// this.onRemove = function;
	// }

}
