package de.nitwit.commons.collections;

import java.util.Map;

import org.apache.commons.functor.BinaryFunction;
import org.apache.commons.functor.BinaryProcedure;
import org.apache.commons.functor.Function;
import org.apache.commons.functor.Procedure;
import org.apache.commons.functor.UnaryFunction;
import org.apache.commons.functor.UnaryProcedure;
import org.apache.commons.functor.adapter.IgnoreLeftFunction;
import org.apache.commons.functor.core.Identity;
import org.apache.commons.functor.core.IsNull;
import org.apache.commons.functor.core.composite.Conditional;

/**
 * @author Timo Nentwig
 */
public class NotNullFunctorMap extends FunctorMap
{

	/**
	 * Factory method to create a default value map.
	 * 
	 * @param map
	 *            the map to decorate, must not be null
	 * @throws IllegalArgumentException
	 *             if map is null
	 */
	public static Map decorate( final Map map )
	{
		return new NotNullFunctorMap( map );
	}

	protected NotNullFunctorMap( final Map map )
	{
		super( map );
		setOnPut( IgnoreLeftFunction.adapt( Conditional.function( IsNull.instance(), (UnaryFunction)throwNPE, Identity.instance() ) ) );
	}

	/*
	 * (This "UniversalFunctor" type provides a functor that takes the same
	 * action regardless of the number of parameters. We used it above to throw
	 * Exceptions when needed.)
	 */

	public abstract class NullPointerFunctor implements UnaryFunction
	{
		protected abstract void run();

		public Object evaluate( Object obj )
		{
			run();
			return null;
		}
	}

	private NullPointerFunctor throwNPE = new NullPointerFunctor()
	{
		public void run()
		{
			throw new NullPointerException( "Null values not allowed." );
		}
	};

}
