# Script to remove unwanted sgf tags from sgf files
# Adapt the $tag list as required
# Written by D.Gilder 2007

use strict;
use warnings;
use IO::File;
use English qw(-no_match_vars);

my $file = shift;
my $fh = IO::File->new($file, '<') or die $ERRNO;
my $sgfdata;

{
  local $INPUT_RECORD_SEPARATOR = undef; # enable localized slurp mode
  $sgfdata = <$fh>;
}

for my $tag ('CR', 'TW', 'TB', 'LB', 'TR', 'WL', 'BL', 'OB', 'OW') {
  $sgfdata =~ s/$tag(\[.*?\])+//g
}
# The following line removes comments
$sgfdata =~ s/(?<!P)C\[.*?(?<!\\)\]//gs; # remove all comments
$fh->close or die $ERRNO;
$fh = IO::File->new($file, '>') or die $ERRNO;
print $fh $sgfdata, "\n";
$fh->close or die $ERRNO;
