#!/bin/bash

## creates a boot.img file in the current directory
## this file contains a grub boot floppy adapted to the current system
## just create the floppy with dd if=./boot.img of=/dev/fd0

## B. Bodin january 2000



## step 0 : parsing arguments and initialisation
## ---------------------------------------------

[[ "$UID" == "0" ]] || {
    echo "Only root can run `basename $0`"
    exit 1;
}

echo "remove any removable disk (cdrom, zip, etc...) and hit [return]"
read

grubdir=/boot/grub
tempdir=/tmp/grub
mkdir -p $tempdir
mount_point=/tmp/floppy
image=boot.img

if [ ! -f $grubdir/stage1 ]
then
  echo "file stage1 in $grubdir missing"
  exit1
fi

if [ ! -f $grubdir/stage2 ]
then
  echo "file stage2 in $grubdir missing"
  exit1
fi

kernel=/boot/vmlinuz
param=""

while getopts "k:p:" opt
do
 case $opt in
   k) kernel=$OPTARG;;
   p) param=$OPTARG;;
   \? ) echo "usage : `basename $0` [ -k kernel ] [ -p boot_param ]" ; exit 1;;
 esac
done

#if [ $# -eq 1 ]
#then
#  kernel=$1
#fi

if  [ ! -f $kernel ]
then
  echo "the file $kernel do not exist !"
  exit 1
fi

## step 1 : the disks geometries
## -----------------------------

## this function puts the output of the geometry(hd$number) grub
## command into the $file$number file.

## two arguments : the numbre of the disk (grub's notation) 
## and the basename of the outuput file.

function disk_geometry() {
  if [ $# -ne 2 ]
  then
    echo "usage disk_geometry number file"
    exit 1
  fi
  result=$2$1
/usr/sbin/grub --batch <<EOF > $result 2> /dev/null
geometry (hd$1)
quit
EOF


if [ `grep "does not exist" $2$1 | wc -l` -eq 1 ]
then
#  echo "disk $1 does not exist"
  rm -f $result
  return 1
else
#  echo "disk $1 OK"
  return 0
fi
} ## end function disk_geometry

## loop overs disks
## ---------------

number=0
file=$tempdir/geom
disk_geometry $number $file
until [[ ! -f $file$number ]]
do
  number=$(($number+1))
  disk_geometry $number $file
done

## step 2 : writing the menu.lst.custom file
## --------------------------------

target=menu.lst.custom

echo default 0 > $target
echo timeout 30 >> $target
echo color 0x03 >> $target
echo " " >> $target

## scanning of the running linux system
## ------------------------------------

root_dev=`df / | grep dev | cut -d\  -f1`
kernel_dev=`df $kernel | grep dev | cut -d\  -f1`

kernel_part=${kernel_dev##*[a-z/]}
kernel_part=$(($kernel_part-1))
kernel_disk=`grep -l ${kernel_dev%[0-9]} ${file}*`
kernel_disk=${kernel_disk##$file}

base_path=`grep $kernel_dev /etc/fstab | cut -d\  -f2`
base_path=${base_path%/}
kernel=${kernel##$base_path}

echo title GNU/Linux-Mandrake >> $target
echo kernel \(hd$kernel_disk,$kernel_part\)$kernel root=$root_dev $param >> $target

echo " " >> $target

## first fat or vfat partition : 
## ----------------------------

disk=`grep -l fat ${file}* | head -n 1`
disk=${disk##$file}
part=`grep fat ${file}${disk} |  cut -d, -f1 | cut -d: -f2`
part=${part## }

root="root="\(hd$disk,$part\)
echo title Windows 9x >> $target
echo $root >> $target
echo makeactive >> $target
echo chainloader +1 >> $target
echo "" >> $target

## the intall part is useless for the hd version
cp $target $grubdir/menu.lst

## installation command
## --------------------

grub_dev=`df $grubdir | grep dev | cut -d\  -f1`

grub_part=${grub_dev##*[a-z/]}
grub_part=$(($grub_part-1))
grub_disk=`grep -l ${grub_dev%[0-9]} ${file}*`
grub_disk=${grub_disk##$file}

base_path=`grep $grub_dev /etc/fstab | cut -d\  -f2`
base_path=${base_path%/}
install_grubdir=${grubdir##$base_path}


echo title Install grub on hard drive >> $target
echo root=\(hd$grub_disk,$grub_part\)  >> $target
echo install $install_grubdir/stage1 d \(hd0\) $install_grubdir/stage2 p \
		$install_grubdir/menu.lst >> $target

echo " " >> $target
echo title Install grub on hard drive \(lba mode\) >> $target
echo root=\(hd$grub_disk,$grub_part\)  >> $target
echo install $install_grubdir/stage1_lba d \(hd0\) $install_grubdir/stage2 p \
		$install_grubdir/menu.lst >> $target


## step 3 : creation of boot floppy
## --------------------------------

rm -rf $image $mount_point
dd if=/dev/zero of=$image bs=1k count=1440
/sbin/mke2fs -F $image  >> /dev/null
mkdir -p $mount_point
mount  -o loop -t ext2 $image $mount_point
mkdir -p $mount_point/boot/grub
cp $grubdir/stage1 $mount_point/boot/grub
cp $grubdir/stage2 $mount_point/boot/grub
cp $target         $mount_point/boot/grub/menu.lst
umount $mount_point

/usr/sbin/grub --batch << EOF >> /dev/null
device (fd0) ./$image
install (fd0)/boot/grub/stage1 (fd0) (fd0)/boot/grub/stage2 p
quit
EOF


## cleaning

rm -rf /tmp/floppy
#rm -rf $tempdir





