#!/bin/sh

echo ${1}
echo ${2}
echo ${3}
echo ${4}

find ${1}/OK -type f -mtime +7 -exec rm -rf {} \;
find ${1}/problem -type f -mtime +7 -exec rm -rf {} \;
find ${3} -type f -mtime +7 -exec rm -rf {} \;

ls -R ${1} | sort | sed s/.txt// | grep src.rpm > /tmp/${4}_LOG.txt
ls -R ${2} | sort | grep mdk.src.rpm > /tmp/${4}_SRPMS.txt
diff /tmp/${4}_LOG.txt /tmp/${4}_SRPMS.txt | grep ">" | cut -b 3-100 > /tmp/${4}_NEW.txt
diff /tmp/${4}_LOG.txt /tmp/${4}_SRPMS.txt | grep "<" | cut -b 3-100 > /tmp/${4}_OLD.txt
rm -rf /tmp/${4}_LOG.txt /tmp/${4}_SRPMS.txt

for i in `cat /tmp/${4}_OLD.txt`; do find ${1} -name ${i}.txt -exec rm -rf {} \; ; done
rm -rf /tmp/${4}_OLD.txt

echo "Starting to compile"

for i in `cat /tmp/${4}_NEW.txt`
	do
	echo ${i};
	rpm --rebuild ${2}/${i} &> ${1}/${i}.txt;

	if [ "$(tail --lines 1 ${1}/${i}.txt)" = "+ exit 0" ];
	then
		mv ${1}/${i}.txt ${1}/OK/

	elif [ "$(tail -n2 ${1}/${i}.txt | head -n1 \
		| cut -b 0-12)" = "Architecture" ];
	then
		mv ${1}/${i}.txt ${1}/arch_excl/

	elif [ "$(tail -n2 ${1}/${i}.txt | head -n1 \
		| cut -b 0-37)" = "source package expected, binary found" ];
	then
		mv ${1}/${i}.txt ${1}/broken/

	elif [ "$(tail -n1 ${1}/${i}.txt | cut -b 0-15)" = "Bad exit status" ];
	then
		mv ${1}/${i}.txt ${1}/problem/
	fi

	mv -f -v ~/RPM/RPMS/alpha/* ${3}
	#mv -f -v ~/RPM/RPMS/i686/* ${3}
	mv -f -v ~/RPM/RPMS/noarch/* ${3}
	find ~/RPM/RPMS/ -type f -exec rm -rf {} \;
	rm -rf ~/RPM/BUILD/*
	rm -rf ~/RPM/SOURCES/*
	rm -rf ~/RPM/SPECS/*
	rm -rf ~/tmp/*
	rm -rf /var/tmp/*

done
rm -rf /tmp/${4}_NEW.txt
echo "Compile finished"
