#!/bin/sh
export RESULTS=/misc/linux/mandrake/results
export B_OUT_DIR=/misc/linux/mandrake/buildout
export B_TYPE=cooker
export MIRROR=/mirrors/SRPMS

# Cleanup first
killall rpm build.sh
rm -rf /var/tmp/*
rm -rf ~/RPM/BUILD/*
find ~/RPM/ -type f -exec rm -rf {} \;
rm -rf ${B_OUT_DIR}/${B_TYPE}/${HOSTTYPE}/*.txt
rm -rf ${B_OUT_DIR}/${B_TYPE}/${HOSTTYPE}/broken/*.txt

/misc/linux/mandrake/bin/build.sh \
		${B_OUT_DIR}/${B_TYPE}/${HOSTTYPE} \
		${MIRROR} \
		/misc/linux/mandrake/${B_TYPE} \
		${B_TYPE}

rm -rf ${RESULTS}/*${B_TYPE}*

ls ${B_OUT_DIR}/${B_TYPE}/alpha/problem > ${RESULTS}/prob_${B_TYPE}_alpha.txt
ls ${B_OUT_DIR}/${B_TYPE}/i586/problem > ${RESULTS}/prob_${B_TYPE}_i586.txt

diff ${RESULTS}/prob_${B_TYPE}_alpha.txt ${RESULTS}/prob_${B_TYPE}_i586.txt \
| grep "<" | cut -b3-30 > ${RESULTS}/${B_TYPE}_alpha.txt
diff ${RESULTS}/prob_${B_TYPE}_alpha.txt ${RESULTS}/prob_${B_TYPE}_i586.txt \
| grep ">" | cut -b3-30 > ${RESULTS}/${B_TYPE}_intel.txt

cat ${RESULTS}/prob_${B_TYPE}_alpha.txt ${RESULTS}/prob_${B_TYPE}_i586.txt | sort \
| uniq -d > ${RESULTS}/${B_TYPE}_common.txt

rm -rf ${RESULTS}/prob*
