#!/bin/sh
export RESULTS=/misc/linux/mandrake/results
export B_OUT_DIR=/misc/linux/mandrake/buildout
export B_TYPE=crypto
export MIRROR=/mirrors/crypto/SRPMS

/misc/linux/mandrake/bin/build.sh \
		${B_OUT_DIR}/${B_TYPE}/${HOSTTYPE} \
		${MIRROR} \
		/misc/linux/mandrake/${B_TYPE} \
		${B_TYPE}

rm -rf ${RESULTS}/*${B_TYPE}*

ls ${B_OUT_DIR}/${B_TYPE}/alpha/problem > ${RESULTS}/prob_${B_TYPE}_alpha.txt
ls ${B_OUT_DIR}/${B_TYPE}/i586/problem > ${RESULTS}/prob_${B_TYPE}_i586.txt

diff ${RESULTS}/prob_${B_TYPE}_alpha.txt ${RESULTS}/prob_${B_TYPE}_i586.txt \
| grep "<" | cut -b3-30 > ${RESULTS}/${B_TYPE}_alpha.txt
diff ${RESULTS}/prob_${B_TYPE}_alpha.txt ${RESULTS}/prob_${B_TYPE}_i586.txt \
| grep ">" | cut -b3-30 > ${RESULTS}/${B_TYPE}_intel.txt

cat ${RESULTS}/prob_${B_TYPE}_alpha.txt ${RESULTS}/prob_${B_TYPE}_i586.txt | sort \
| uniq -d > ${RESULTS}/${B_TYPE}_common.txt

rm -rf ${RESULTS}/prob*
