/*
 * This file is part of the superiotool project.
 *
 * Copyright (C) Anton Kochkov <anton.kochkov@gmail.com>
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

#include "msrtool.h"
#include <stdio.h>

struct cpuid_t* cpuid(void) {return 0;}
struct pci_dev *pci_dev_find(uint16_t vendor, uint16_t device) {
	return NULL;
}

#include "k8.c"
#include "geodelx.c"
#include "geodegx2.c"
#include "cs5536.c"

#define ARRAY_SIZE(a) ((int)(sizeof(a) / sizeof((a)[0])))

typedef struct {
	long offset;
	char *name;
} msr_entry_t;

void export_msr(FILE *stream, const struct msrdef *msarray, char* name, char* description) {
	int i = 0, j = 0, k = 0;
	char *msr_type;
	char *bitfield_type;

	fprintf(stream, "<msrarray name=\"%s\" description=\"%s\">\n", name, description);
	fprintf(stream, "<cpu family=\"0x6\" model=\"0x17\" stepping=\"5\" />\n");

	i = 0;
	while (msarray[i].type != MSRTYPE_EOT) {
		if (msarray[i].symbol != NULL) {
			if (msarray[i].type == MSRTYPE_WRONLY) msr_type = "wo";
			else if (msarray[i].type == MSRTYPE_RDWR) msr_type = "rw";
			else msr_type = "ro"; // MSRTYPE_RDONLY
			
			fprintf(stream, "<msr address=\"0x%x\" type=\"%s\" name=\"%s\" description=\"%s\">\n", msarray[i].addr, msr_type, msarray[i].symbol, msarray[i].desc);
			j = 0;
			while (msarray[i].bits[j].size != 0 ) {
				if (msarray[i].bits[j].name != NULL) {
					if (msarray[i].bits[j].present == 	PRESENT_RSVD) bitfield_type = "reserved";
					else if (msarray[i].bits[j].present == PRESENT_DEC) bitfield_type = "dec";
					else if (msarray[i].bits[j].present == PRESENT_BIN) bitfield_type = "bin";
					else if (msarray[i].bits[j].present == PRESENT_OCT) bitfield_type = "oct";
					else if (msarray[i].bits[j].present ==	PRESENT_HEX) bitfield_type = "hex";
					else bitfield_type = "hex"; // what is it??	PRESENT_HEXDEC

					fprintf(stream, "<bitfield start=\"%d\" size=\"%d\" name=\"%s\" description=\"%s\" type=\"%s\">\n", msarray[i].bits[j].start, msarray[i].bits[j].size, msarray[i].bits[j].name, msarray[i].bits[j].desc, bitfield_type);
					k = 0;
					while (msarray[i].bits[j].bitval[k].text != NULL) {
						fprintf(stream, "<value number=\"%d\" description=\"%s\" />\n", msarray[i].bits[j].bitval[k].value.lo, msarray[i].bits[j].bitval[k].text);
					k++;
					}
					fprintf(stream, "</bitfield>\n");
				}
			j++;
			}
			fprintf(stream, "</msr>\n");
		}
	i++;
	}
	fprintf(stream, "</msrarray>\n");
}

int main(int argc, char** argv){

	FILE *stream;

	stream = fopen("k8.msr.xml", "w");
	export_msr(stream, k8_msrs, "k8", "bla-bla");
	fclose(stream);

	stream = fopen("cs5536.msr.xml", "w");
	export_msr(stream, cs5536_msrs, "cs5536", "dont seen before");
	fclose(stream);

	stream = fopen("geodelx.msr.xml", "w");
	export_msr(stream, geodelx_msrs, "geodelx", "what is this?");
	fclose(stream);

	stream = fopen("geodegx2.msr.xml", "w");
	export_msr(stream, geodegx2_msrs, "geodegx2", "is it very different from geodelx?");
	fclose(stream);

	return 0;
}
