/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (pcopy-opts.c)
 *  
 *  It has been AutoGen-ed  April 27, 2012 at 06:58:56 PM by AutoGen 5.16pre32
 *  From the definitions    pcopy-opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 36:4:11 templates.
 *
 *  AutoOpts is a copyrighted work.  This source file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the pcopy author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The pcopy program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2012 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the
 *  GNU General Public License, version 3 or later
 *      <http://gnu.org/licenses/gpl.html>
 *
 *  pcopy is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  pcopy is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */

#define OPTION_CODE_COMPILE 1
#include "pcopy-opts.h"
#include <sys/types.h>
#include <sys/stat.h>

#include <ctype.h>
#include <errno.h>
#include <fcntl.h>
#include <limits.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <unistd.h>

#ifdef  __cplusplus
extern "C" {
#endif
extern FILE * option_usage_fp;

/* TRANSLATORS: choose the translation for option names wisely because you
                cannot ever change your mind. */
#define zCopyright      (pcopy_opt_strs+0)
#define zLicenseDescrip (pcopy_opt_strs+251)

extern tUsageProc optionUsage;
/*
 *  global included definitions
 */
pthread_t  * pth_list = NULL;
pthread_mutex_t tty_mutex = PTHREAD_MUTEX_INITIALIZER;

#ifndef NULL
#  define NULL 0
#endif

/*
 *  pcopy option static const strings
 */
static char const pcopy_opt_strs[1583] =
/*     0 */ "pcopy 0.2\n"
            "Copyright (C) 2012 Bruce Korb, all rights reserved.\n"
            "This is free software. It is licensed for use, modification and\n"
            "redistribution under the terms of the\n"
            "GNU General Public License, version 3 or later\n"
            "    <http://gnu.org/licenses/gpl.html>\n\0"
/*   251 */ "pcopy is free software: you can redistribute it and/or modify it under the\n"
            "terms of the GNU General Public License as published by the Free Software\n"
            "Foundation, either version 3 of the License, or (at your option) any later\n"
            "version.\n\n"
            "pcopy is distributed in the hope that it will be useful, but WITHOUT ANY\n"
            "WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS\n"
            "FOR A PARTICULAR PURPOSE.  See the GNU General Public License for more\n"
            "details.\n\n"
            "You should have received a copy of the GNU General Public License along\n"
            "with this program.  If not, see <http://www.gnu.org/licenses/>.\n\0"
/*   850 */ "max number of copy threads\0"
/*   877 */ "THREAD_CT\0"
/*   887 */ "thread-ct\0"
/*   897 */ "destination directory or file name\0"
/*   932 */ "DESTINATION\0"
/*   944 */ "destination\0"
/*   956 */ "Display extended usage information and exit\0"
/*  1000 */ "help\0"
/*  1005 */ "Extended usage information passed thru pager\0"
/*  1050 */ "more-help\0"
/*  1060 */ "Output version information and exit\0"
/*  1096 */ "version\0"
/*  1104 */ "Abbreviated usage to stdout\0"
/*  1132 */ "usage\0"
/*  1138 */ "Save the option state to a config file\0"
/*  1177 */ "save-opts\0"
/*  1187 */ "Load options from a config file\0"
/*  1219 */ "LOAD_OPTS\0"
/*  1229 */ "no-load-opts\0"
/*  1242 */ "no\0"
/*  1245 */ "PCOPY\0"
/*  1251 */ "pcopy - Parallel copy - Ver. 0.2\n"
            "USAGE:  %s [ -<flag> [<val>] | --<name>[{=| }<val>] ]... [ <file> ... ]\n\0"
/*  1357 */ "$HOME\0"
/*  1363 */ ".\0"
/*  1365 */ ".pcopyrc\0"
/*  1374 */ "autogen-users@lists.sourceforge.net\0"
/*  1410 */ "\n"
            "If no arguments are provided, input arguments are read from stdin,\n"
            "one per line; blank and '#'-prefixed lines are comments.\n"
            "'stdin' may not be a terminal (tty).\n\0"
/*  1573 */ "pcopy 0.2";

/*
 *  thread-ct option description:
 */
#define THREAD_CT_DESC      (pcopy_opt_strs+850)
#define THREAD_CT_NAME      (pcopy_opt_strs+877)
#define THREAD_CT_name      (pcopy_opt_strs+887)
#define THREAD_CT_DFT_ARG   ((char const*)8)
#define THREAD_CT_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_NUMERIC))

/*
 *  destination option description:
 */
#define DESTINATION_DESC      (pcopy_opt_strs+897)
#define DESTINATION_NAME      (pcopy_opt_strs+932)
#define DESTINATION_name      (pcopy_opt_strs+944)
#define DESTINATION_FLAGS     (OPTST_DISABLED \
        | OPTST_SET_ARGTYPE(OPARG_TYPE_STRING))

/*
 *  Help/More_Help/Version option descriptions:
 */
#define HELP_DESC       (pcopy_opt_strs+956)
#define HELP_name       (pcopy_opt_strs+1000)
#ifdef HAVE_WORKING_FORK
#define MORE_HELP_DESC  (pcopy_opt_strs+1005)
#define MORE_HELP_name  (pcopy_opt_strs+1050)
#define MORE_HELP_FLAGS (OPTST_IMM | OPTST_NO_INIT)
#else
#define MORE_HELP_DESC  NULL
#define MORE_HELP_name  NULL
#define MORE_HELP_FLAGS (OPTST_OMITTED | OPTST_NO_INIT)
#endif
#ifdef NO_OPTIONAL_OPT_ARGS
#  define VER_FLAGS     (OPTST_IMM | OPTST_NO_INIT)
#else
#  define VER_FLAGS     (OPTST_SET_ARGTYPE(OPARG_TYPE_STRING) | \
                         OPTST_ARG_OPTIONAL | OPTST_IMM | OPTST_NO_INIT)
#endif
#define VER_DESC        (pcopy_opt_strs+1060)
#define VER_name        (pcopy_opt_strs+1096)
#define USAGE_DESC      (pcopy_opt_strs+1104)
#define USAGE_name      (pcopy_opt_strs+1132)
#define SAVE_OPTS_DESC  (pcopy_opt_strs+1138)
#define SAVE_OPTS_name  (pcopy_opt_strs+1177)
#define LOAD_OPTS_DESC     (pcopy_opt_strs+1187)
#define LOAD_OPTS_NAME     (pcopy_opt_strs+1219)
#define NO_LOAD_OPTS_name  (pcopy_opt_strs+1229)
#define LOAD_OPTS_pfx      (pcopy_opt_strs+1242)
#define LOAD_OPTS_name     (NO_LOAD_OPTS_name + 3)
/*
 *  Declare option callback procedures
 */
extern tOptProc
    optionBooleanVal,   optionNestedVal,    optionNumericVal,
    optionPagedUsage,   optionPrintVersion, optionResetOpt,
    optionStackArg,     optionTimeDate,     optionTimeVal,
    optionUnstackArg,   optionVendorOption;
static tOptProc
    doUsageOpt;
#define VER_PROC        optionPrintVersion

/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the pcopy Option Descriptions.
 */
static tOptDesc optDesc[OPTION_CT] = {
  {  /* entry idx, value */ 0, VALUE_OPT_THREAD_CT,
     /* equiv idx, value */ 0, VALUE_OPT_THREAD_CT,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ THREAD_CT_FLAGS, 0,
     /* last opt argumnt */ { THREAD_CT_DFT_ARG },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionNumericVal,
     /* desc, NAME, name */ THREAD_CT_DESC, THREAD_CT_NAME, THREAD_CT_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ 1, VALUE_OPT_DESTINATION,
     /* equiv idx, value */ 1, VALUE_OPT_DESTINATION,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ DESTINATION_FLAGS, 0,
     /* last opt argumnt */ { NULL }, /* --destination */
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ DESTINATION_DESC, DESTINATION_NAME, DESTINATION_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_VERSION, VALUE_OPT_VERSION,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_VERSION,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ VER_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ VER_PROC,
     /* desc, NAME, name */ VER_DESC, NULL, VER_name,
     /* disablement strs */ NULL, NULL },



  {  /* entry idx, value */ INDEX_OPT_HELP, VALUE_OPT_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM | OPTST_NO_INIT, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ HELP_DESC, NULL, HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_MORE_HELP, VALUE_OPT_MORE_HELP,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_MORE_HELP,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ MORE_HELP_FLAGS, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ optionPagedUsage,
     /* desc, NAME, name */ MORE_HELP_DESC, NULL, MORE_HELP_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_USAGE, VALUE_OPT_USAGE,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_USAGE,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_IMM | OPTST_NO_INIT, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ doUsageOpt,
     /* desc, NAME, name */ USAGE_DESC, NULL, USAGE_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_SAVE_OPTS, VALUE_OPT_SAVE_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_SAVE_OPTS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, 1, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
                          | OPTST_ARG_OPTIONAL | OPTST_NO_INIT, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL,  NULL,
     /* option proc      */ NULL,
     /* desc, NAME, name */ SAVE_OPTS_DESC, NULL, SAVE_OPTS_name,
     /* disablement strs */ NULL, NULL },

  {  /* entry idx, value */ INDEX_OPT_LOAD_OPTS, VALUE_OPT_LOAD_OPTS,
     /* equiv idx value  */ NO_EQUIVALENT, VALUE_OPT_LOAD_OPTS,
     /* equivalenced to  */ NO_EQUIVALENT,
     /* min, max, act ct */ 0, NOLIMIT, 0,
     /* opt state flags  */ OPTST_SET_ARGTYPE(OPARG_TYPE_STRING)
			  | OPTST_DISABLE_IMM, 0,
     /* last opt argumnt */ { NULL },
     /* arg list/cookie  */ NULL,
     /* must/cannot opts */ NULL, NULL,
     /* option proc      */ optionLoadOpt,
     /* desc, NAME, name */ LOAD_OPTS_DESC, LOAD_OPTS_NAME, LOAD_OPTS_name,
     /* disablement strs */ NO_LOAD_OPTS_name, LOAD_OPTS_pfx }
};


/* * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * * *
 *
 *  Define the pcopy Option Environment
 */
#define zPROGNAME       (pcopy_opt_strs+1245)
#define zUsageTitle     (pcopy_opt_strs+1251)
#define zRcName         (pcopy_opt_strs+1365)
static char const * const apzHomeList[3] = {
    pcopy_opt_strs+1357,
    pcopy_opt_strs+1363,
    NULL };
#define zBugsAddr       (pcopy_opt_strs+1374)
#define zExplain        (pcopy_opt_strs+1410)
#define zDetail         (NULL)
#define zFullVersion    (pcopy_opt_strs+1573)
/* extracted from optcode.tlib near line 348 */

#define OPTPROC_BASE OPTPROC_NONE
#define translate_option_strings NULL


#define pcopy_full_usage (NULL)

#define pcopy_short_usage (NULL)

/*
 *  Create the static procedure(s) declared above.
 */
/**
 * The callout function that invokes the USAGE() macro.
 *
 * @param pOptions the AutoOpts option description structure
 * @param pOptDesc the descriptor for the "help" (usage) option.
 */
static void
doUsageOpt(tOptions * pOptions, tOptDesc * pOptDesc)
{
    int ex_code = (pOptDesc->optIndex == INDEX_OPT_HELP)
        ? PCOPY_EXIT_SUCCESS : AO_EXIT_REQ_USAGE;
    USAGE(ex_code);
    (void)pOptions;
}
/* extracted from optmain.tlib near line 120 */

/**
 * strip (destructively) the leading and trailing white space.
 * Trailing white space is trimmed with a NUL byte.
 * The returned address is that of the first character after the
 * leading white space.  Characters are not moved.
 *
 * @param pz_s source text pointer
 * @returns pointer to the same text buffer, but after finding the
 * first non-white space character.
 */
static char *
trim_input_line(char * pz_s)
{
    char* pz_e = pz_s + strlen(pz_s); /*!< terminating NUL byte */
    while ((pz_e > pz_s) && isspace((unsigned int)pz_e[-1]))  pz_e--;
    *pz_e = '\0';
    while ((unsigned int)isspace(*pz_s))  pz_s++;

    switch (*pz_s) {
    case '\0':
    case '#':
        return NULL;
    default:
        return pz_s;
    }
}

extern int pcopy(char const* pz_fname);
/* extracted from optmain.tlib near line 193 */

/**
 * validate file name and dispach callout procedure.
 * This procedure is generated by AutoOpts.
 * It will make sure that the input file name refers to a file
 * that exists.
 *
 * @param pz_fname the name of the file to process
 * @returns program exit code flag
 */
static pcopy_exit_code_t
validate_fname(char const* pz_fname)
{
    static char const * pz_fs_err = NULL;

    if (pz_fs_err == NULL)
        pz_fs_err = _("fs error %d (%s) %s-ing %s\n");

    {
        struct stat sb;
        if (stat(pz_fname, &sb) < 0) {
            fprintf(stderr, pz_fs_err, errno, strerror(errno), "stat",
                    pz_fname);
            return PCOPY_EXIT_FAILURE;
        }
    }
/* extracted from optmain.tlib near line 278 */


    return pcopy(pz_fname);
}
/* extracted from optmain.tlib near line 357 */

/**
 * Generated main procedure.  This will call the validate_fname procedure
 * for every operand on the command line.  If there are no operands, then stdin
 * is read for a list of file names to process.  stdin must not be a terminal.
 * It must be a pipe or a file.
 *
 * @param argc argument count
 * @param argv argument vector
 * @returns program exit code
 */
int
main(int argc, char** argv)
{
    int res = 0;
    {
        int ct = optionProcess(&pcopyOptions, argc, argv);
        argc -= ct;
        argv += ct;
    }
    
/* extracted from pcopy-opts.def near line 39 */

    initscr();
    pth_list = malloc(OPT_VALUE_THREAD_CT * sizeof(*pth_list));
    if (pth_list == NULL) {
        errno = ENOMEM;
        fserr(PCOPY_EXIT_NO_MEM, "allocate", "pthread list");
    }
/* extracted from optmain.tlib near line 382 */

    /*
     *  Input list from command line
     */
    if (argc > 0) {
        do  {
            res |= validate_fname(*(argv++));
        } while (--argc > 0);
    }

    /*
     *  Input list from tty input
     */
    else if (isatty(STDIN_FILENO)) {
        fputs(_("pcopy ERROR: input list is a tty\n"), stderr);
        USAGE(PCOPY_EXIT_FAILURE);
        /* NOTREACHED */
    }

    /*
     *  Input list from a pipe or file or some such
     */
    else {
        int in_ct   = 0;
        size_t pg_size = getpagesize();
        char* buf   = malloc(pg_size);
        if (buf == NULL) {
            fputs(_("pcopy ERROR: no memory for input list\n"), stderr);
            return PCOPY_EXIT_FAILURE;
        }

        for (;;) {
            char* pz = fgets(buf, (ssize_t)pg_size, stdin);
            if (pz == NULL)
                break;

            pz = trim_input_line(pz);
            if (pz != NULL) {
                 res |= validate_fname(pz);
                 in_ct++;
            }
        }

        if (in_ct == 0)
            fputs(_("pcopy Warning:  no input lines were read\n"), stderr);
        free(buf);
    }
    
/* extracted from pcopy-opts.def near line 47 */

    endwin();
    return res;
}
/* extracted from optmain.tlib near line 1109 */

/**
 * Print a usage message with a format and va_list argument.
 * The USAGE exit macro is then invoked to print the error usage text
 * (somewhat abbreviated) and then exit.
 *
 * @param[in] fmt the message format string
 * @param[in] ap  the var-arg list.
 * @noreturn
 */
void
vusage_message(char const * fmt, va_list ap)
{
    char const * er_leader = _("pcopy usage error:\n");
    fputs(er_leader, stderr);
    vfprintf(stderr, fmt, ap);
    USAGE(PCOPY_EXIT_FAILURE);
    /* NOTREACHED */
}

/**
 * Print a usage message with a format and a variable argument list. 
 * vusage_message() is called to do the work.
 *
 * @param[in] fmt the message format string
 * @param[in] ... the argument list for the message
 * @noreturn
 */
void
usage_message(char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vusage_message(fmt, ap);
    /* NOTREACHED */
    va_end(ap);
}

/**
 * Print a fatal error message and die
 *
 * @param[in] exit_code  the value to call exit(3) with
 * @param[in] fmt        the death rattle message
 * @param[in] ap         the argument list for the message
 * @noreturn
 */
void
vdie(int exit_code, char const * fmt, va_list ap)
{
    static char const * die_leader =
        _("pcopy fatal error:\n");

    endwin();

    fputs(die_leader, stderr);
    vfprintf(stderr, fmt, ap);
    fflush(stderr);
    exit(exit_code);
    /* NOTREACHED */
}

/**
 * Print a fatal error message and die
 *
 * @param[in] exit_code  the value to call exit(3) with
 * @param[in] fmt        the death rattle message
 * @param[in] ...        the list of arguments for the message
 * @noreturn
 */
void
die(int exit_code, char const * fmt, ...)
{
    va_list ap;
    va_start(ap, fmt);
    vdie(exit_code, fmt, ap);
    /* NOTREACHED */
    va_end(ap);
}

/**
 * Print a file system error fatal error message and die
 *
 * @param[in] exit_code  the value to call exit(3) with.
 * @param[in] op         the operation that failed.
 * @param[in] fname      the file name the operation was on.
 * @noreturn
 */
void
fserr(int exit_code, char const * op, char const * fname)
{
    static char const * fserr_fmt =
        _("fserr %d (%s) performing '%s' on %s\n");
    die(exit_code, fserr_fmt, errno, strerror(errno), op, fname);
    /* NOTREACHED */
}

#ifndef  PKGDATADIR
# define PKGDATADIR ""
#endif

#ifndef  WITH_PACKAGER
# define pcopy_packager_info NULL
#else
static char const pcopy_packager_info[] =
    "Packaged by " WITH_PACKAGER

# ifdef WITH_PACKAGER_VERSION
        " ("WITH_PACKAGER_VERSION")"
# endif

# ifdef WITH_PACKAGER_BUG_REPORTS
    "\nReport pcopy bugs to " WITH_PACKAGER_BUG_REPORTS
# endif
    "\n";
#endif

tOptions pcopyOptions = {
    OPTIONS_STRUCT_VERSION,
    0, NULL,                    /* original argc + argv    */
    ( OPTPROC_BASE
    + OPTPROC_ERRSTOP
    + OPTPROC_SHORTOPT
    + OPTPROC_LONGOPT
    + OPTPROC_NO_REQ_OPT
    + OPTPROC_ENVIRON ),
    0, NULL,                    /* current option index, current option */
    NULL,         NULL,         zPROGNAME,
    zRcName,      zCopyright,   zLicenseDescrip,
    zFullVersion, apzHomeList,  zUsageTitle,
    zExplain,     zDetail,      optDesc,
    zBugsAddr,                  /* address to send bugs to */
    NULL, NULL,                 /* extensions/saved state  */
    optionUsage, /* usage procedure */
    translate_option_strings,   /* translation procedure */
    /*
     *  Indexes to special options
     */
    { INDEX_OPT_MORE_HELP, /* more-help option index */
      INDEX_OPT_SAVE_OPTS, /* save option index */
      NO_EQUIVALENT, /* '-#' option index */
      NO_EQUIVALENT /* index of default opt */
    },
    8 /* full option count */, 2 /* user option count */,
    pcopy_full_usage, pcopy_short_usage,
    NULL, NULL,
    PKGDATADIR, pcopy_packager_info
};

#ifdef  __cplusplus
}
#endif
/* pcopy-opts.c ends here */
