/*   -*- buffer-read-only: t -*- vi: set ro:
 *  
 *  DO NOT EDIT THIS FILE   (pcopy-opts.h)
 *  
 *  It has been AutoGen-ed  April 27, 2012 at 06:58:56 PM by AutoGen 5.16pre32
 *  From the definitions    pcopy-opts.def
 *  and the template file   options
 *
 * Generated from AutoOpts 36:4:11 templates.
 *
 *  AutoOpts is a copyrighted work.  This header file is not encumbered
 *  by AutoOpts licensing, but is provided under the licensing terms chosen
 *  by the pcopy author or copyright holder.  AutoOpts is
 *  licensed under the terms of the LGPL.  The redistributable library
 *  (``libopts'') is licensed under the terms of either the LGPL or, at the
 *  users discretion, the BSD license.  See the AutoOpts and/or libopts sources
 *  for details.
 *
 * The pcopy program is copyrighted and licensed
 * under the following terms:
 *
 *  Copyright (C) 2012 Bruce Korb, all rights reserved.
 *  This is free software. It is licensed for use, modification and
 *  redistribution under the terms of the
 *  GNU General Public License, version 3 or later
 *      <http://gnu.org/licenses/gpl.html>
 *
 *  pcopy is free software: you can redistribute it and/or modify it
 *  under the terms of the GNU General Public License as published by the
 *  Free Software Foundation, either version 3 of the License, or
 *  (at your option) any later version.
 *  
 *  pcopy is distributed in the hope that it will be useful, but
 *  WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 *  See the GNU General Public License for more details.
 *  
 *  You should have received a copy of the GNU General Public License along
 *  with this program.  If not, see <http://www.gnu.org/licenses/>.
 */
/*
 *  This file contains the programmatic interface to the Automated
 *  Options generated for the pcopy program.
 *  These macros are documented in the AutoGen info file in the
 *  "AutoOpts" chapter.  Please refer to that doc for usage help.
 */
#ifndef AUTOOPTS_PCOPY_OPTS_H_GUARD
#define AUTOOPTS_PCOPY_OPTS_H_GUARD 1
#include "pcopy-cfg.h"
#include <autoopts/options.h>
#include <stdarg.h>

/*
 *  Ensure that the library used for compiling this generated header is at
 *  least as new as the version current when the header template was released
 *  (not counting patch version increments).  Also ensure that the oldest
 *  tolerable version is at least as old as what was current when the header
 *  template was released.
 */
#define AO_TEMPLATE_VERSION 147460
#if (AO_TEMPLATE_VERSION < OPTIONS_MINIMUM_VERSION) \
 || (AO_TEMPLATE_VERSION > OPTIONS_STRUCT_VERSION)
# error option template version mismatches autoopts/options.h header
  Choke Me.
#endif

/*
 *  Enumeration of each option:
 */
typedef enum {
    INDEX_OPT_THREAD_CT    =  0,
    INDEX_OPT_DESTINATION  =  1,
    INDEX_OPT_VERSION      =  2,
    INDEX_OPT_HELP         =  3,
    INDEX_OPT_MORE_HELP    =  4,
    INDEX_OPT_USAGE        =  5,
    INDEX_OPT_SAVE_OPTS    =  6,
    INDEX_OPT_LOAD_OPTS    =  7
} teOptIndex;

#define OPTION_CT    8
#define PCOPY_VERSION       "0.2"
#define PCOPY_FULL_VERSION  "pcopy 0.2"

/*
 *  Interface defines for all options.  Replace "n" with the UPPER_CASED
 *  option name (as in the teOptIndex enumeration above).
 *  e.g. HAVE_OPT(THREAD_CT)
 */
#define         DESC(n) (pcopyOptions.pOptDesc[INDEX_OPT_## n])
#define     HAVE_OPT(n) (! UNUSED_OPT(& DESC(n)))
#define      OPT_ARG(n) (DESC(n).optArg.argString)
#define    STATE_OPT(n) (DESC(n).fOptState & OPTST_SET_MASK)
#define    COUNT_OPT(n) (DESC(n).optOccCt)
#define    ISSEL_OPT(n) (SELECTED_OPT(&DESC(n)))
#define ISUNUSED_OPT(n) (UNUSED_OPT(& DESC(n)))
#define  ENABLED_OPT(n) (! DISABLED_OPT(& DESC(n)))
#define  STACKCT_OPT(n) (((tArgList*)(DESC(n).optCookie))->useCt)
#define STACKLST_OPT(n) (((tArgList*)(DESC(n).optCookie))->apzArgs)
#define    CLEAR_OPT(n) STMTS( \
                DESC(n).fOptState &= OPTST_PERSISTENT_MASK;   \
                if ((DESC(n).fOptState & OPTST_INITENABLED) == 0) \
                    DESC(n).fOptState |= OPTST_DISABLED; \
                DESC(n).optCookie = NULL )

/* * * * * *
 *
 *  Enumeration of pcopy exit codes
 */
typedef enum {
    PCOPY_EXIT_SUCCESS = 0,
    PCOPY_EXIT_FAILURE = 1,
    PCOPY_EXIT_NO_MEM = 2,
    PCOPY_EXIT_FS_ERR_IN = 3,
    PCOPY_EXIT_FS_ERR_OUT = 4,
    PCOPY_EXIT_NO_CONFIG_INPUT = 66,
    PCOPY_EXIT_LIBOPTS_FAILURE = 70
} pcopy_exit_code_t;
/* * * * * *
 *
 *  Interface defines for specific options.
 */
#define VALUE_OPT_THREAD_CT      't'

#define OPT_VALUE_THREAD_CT      (DESC(THREAD_CT).optArg.argInt)
#define VALUE_OPT_DESTINATION    'd'
#define VALUE_OPT_HELP          '?'
#define VALUE_OPT_MORE_HELP     '!'
#define VALUE_OPT_VERSION       'v'
#define VALUE_OPT_USAGE         'u'
#define VALUE_OPT_SAVE_OPTS     '>'
#define VALUE_OPT_LOAD_OPTS     '<'
#define SET_OPT_SAVE_OPTS(a)   STMTS( \
        DESC(SAVE_OPTS).fOptState &= OPTST_PERSISTENT_MASK; \
        DESC(SAVE_OPTS).fOptState |= OPTST_SET; \
        DESC(SAVE_OPTS).optArg.argString = (char const*)(a) )
/*
 *  Interface defines not associated with particular options
 */
#define ERRSKIP_OPTERR  STMTS(pcopyOptions.fOptSet &= ~OPTPROC_ERRSTOP)
#define ERRSTOP_OPTERR  STMTS(pcopyOptions.fOptSet |= OPTPROC_ERRSTOP)
#define RESTART_OPT(n)  STMTS( \
                pcopyOptions.curOptIdx = (n); \
                pcopyOptions.pzCurOpt  = NULL)
#define START_OPT       RESTART_OPT(1)
#define USAGE(c)        (*pcopyOptions.pUsageProc)(&pcopyOptions, c)
/* extracted from opthead.tlib near line 484 */

#ifdef  __cplusplus
extern "C" {
#endif
/*
 *  global exported definitions
 */

#define  _GNU_SOURCE 1
#define  _DARWIN_FEATURE_64_BIT_INODE

#include <sys/stat.h>
#include <sys/types.h>
#include <sys/uio.h>

#include <ncurses.h>  
#include <errno.h>
#include <fcntl.h>
#include <inttypes.h>
#include <pthread.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <term.h>
#include <unistd.h>

#ifndef  NUL
# define NUL '\0'
#endif

typedef struct {
    char const *    fname;
    char *          buffer;
    unsigned long   start;
    unsigned long   end;
    uint32_t        idx;
    char            seg_name[2 * sizeof(char *)];
} file_seg_t;

extern pthread_t  *    pth_list;
extern pthread_mutex_t tty_mutex;

extern void vusage_message(char const * fmt, va_list ap);
extern void usage_message(char const * fmt, ...);


/* * * * * *
 *
 *  Declare the pcopy option descriptor.
 */
extern tOptions pcopyOptions;
# define OPT_NO_XLAT_CFG_NAMES
# define OPT_NO_XLAT_OPT_NAMES

# define OPT_XLAT_CFG_NAMES
# define OPT_XLAT_OPT_NAMES

# ifndef _
#   define _(_s)  _s
# endif

extern void vdie( int exit_code, char const * fmt, va_list);
extern void die(  int exit_code, char const * fmt, ...);
extern void fserr(int exit_code, char const * op, char const * fname);

#ifdef  __cplusplus
}
#endif
#endif /* AUTOOPTS_PCOPY_OPTS_H_GUARD */
/* pcopy-opts.h ends here */
