AC_DEFUN(AC_PROG_CC_WIN32, [
dnl figure out how to run CC with access to the win32 api if present
dnl configure that as the CC program, and set ac_cc_win32 to yes if found
dnl or no if not found. We don't simply abort because
dnl some folk may just want to test their environment and fallback with #defines
dnl in their code.
dnl WIN32 may be present with WINE, under cygwin, or under mingw,
dnl or cross compilers targeting those same three targets.
dnl as it happens, I can only test cygwin, so extra input here will be appreciated
dnl send bug reports to Robert Collins <rbtcollins@hotmail.com>

dnl logic: is CC already configured? if not, call AC_PROG_CC.
dnl if so - try it. If that doesn't work ,try -mwin32. If that doesn't work, fail
dnl
dnl 2001-03-15 - Changed from yes/no to true/false -suggested by Lars J Aas<larsa@sim.no>
dnl

AC_REQUIRE([AC_PROG_CC])
echo $ECHO_N "checking how to access the Win32 API..." >&6
AC_TRY_CPP([#include <windows.h>], [
dnl found windows.h with the current config.
echo "${ECHO_T}Win32 API found by default" >&6
ac_cc_win32=true
], [
dnl try -mwin32
save_cpp="$ac_cpp"
ac_cpp="$ac_cpp -mwin32"
AC_TRY_CPP([#include <windows.h>], [
dnl found windows.h using -mwin32
echo "${ECHO_T}Win32 API found via -mwin32" >&6
ac_cc_win32=true
ac_compile="$ac_compile -mwin32"
ac_link="$ac_link -mwin32"
CC="$CC -mwin32"
], [
ac_cc_win32=false
ac_cpp="$save_cpp"
echo "${ECHO_T}Win32 API Not found" >&6
])
])

AC_PROVIDE([$0])
])
