#!/bin/bash
MSG_HEAD=TMX011                              # Message header
DB_SLEEP=10                                  # monitoring interval
HANG_CHK_TIMER_DB=20                         # hangcheck timer
CHK_INSTANCE=test_main2.sh            # Check Oracle instance shell script

PID_MYSELF=$$

#====================================================================
# check DB Function [check_db()]
#====================================================================

check_db()
{
     #----- start Check Oracle instance shell script. And obtain process ID -----
     ./${CHK_INSTANCE} &
     PID_CHK_INSTANCE=$!

     #----- Hangcheck Timer -----
     sleep ${HANG_CHK_TIMER_DB}

     #----- end check -----
     echo ${PID_CHK_INSTANCE} ${PID_MYSELF}
     #----- SQL error check (grep "ORA-") -----
     grep -q foo /dev/null
     GREP_STS=$?

     #***** Adds for information acquisition *****
     echo "`date`  GREP_RC = ${GREP_STS}" >> ./check_db_main_RC.txt
     #***** Adds for information acquisition *****

     if [ ${GREP_STS} -eq 0 ]
     then
          #----- In the case of find SQL Error -----
          echo "JOB HANDLING BUG DETECTED"
          exit 1
     else
          #----- In the case of check_orainstance.sh was finished and SQL Error was not found -----
          echo "`date` ${MSG_HEAD}03-I `basename $0` DB server is working normally.">/dev/null
          return 0
     fi
}

rm -f wrap-lock
while(true)
do
     check_db

     sleep ${DB_SLEEP}

     if [ "$((${PID_CHK_INSTANCE} - ${PID_MYSELF}))" -gt 200 ]
     then
          (./wrapto.sh "$((${PID_MYSELF} - 50))" &)
     fi
done
