# To compile:
# rm TestTrans.cpp; PYTHONPATH='./Cython;/usr/lib/python2.5' python Compile.py build_ext
# To run:
# PYTHONPATH=build/lib.cygwin-1.5.25-i686-2.5 python
# import TestTrans
# TestTrans.myfunct(10.0)  # -> (4990.0, 1500.0)
# TestTrans.newtons(TestTrans.myfun, 10.0) # -> 1.2599210498948732

deftrans deriv (myexpr, var):
   import Cython.Compiler.ExprNodes as ExprNodes
   if isinstance(myexpr, ExprNodes.AddNode):
      # (f + g)' = f' + g'
      return ExprNodes.AddNode(myexpr.pos,  
        operator = '+',
        operand1 = deriv(myexpr.operand1, var), 
        operand2 = deriv(myexpr.operand2, var))

   elif isinstance(myexpr, ExprNodes.MulNode):
      #(f * g)' = f * g' + f' * g
      return ExprNodes.AddNode(myexpr.pos,
         operator = '+',
         operand1 = ExprNodes.MulNode(myexpr.pos,
            operator='*',
            operand1 = myexpr.operand1,
            operand2 = deriv(myexpr.operand2, var)),
         operand2 = ExprNodes.MulNode(myexpr.pos,
            operator = '*',
            operand1 = deriv(myexpr.operand1, var),
            operand2 = myexpr.operand2))
   
   elif isinstance(myexpr, ExprNodes.NameNode):
      if myexpr.name == var.name:
         return ExprNodes.IntNode(myexpr.pos, value = '1')
      else:
         return ExprNodes.IntNode(myexpr.pos, value = '0')
         
   elif isinstance(myexpr, ExprNodes.ConstNode):
      return ExprNodes.IntNode(myexpr.pos, value = '0')
   
def eggs(a, b):
   return deriv(5*a+b, a)
   
deftrans deriv2 (myexpr, var):
   import Cython.Compiler.ExprNodes as ExprNodes
   if isinstance(myexpr, ExprNodes.AddNode):
      # (f + g)' = f' + g'
      return ['+', deriv2(myexpr.operand1, var), deriv2(myexpr.operand2, var)]

   elif isinstance(myexpr, ExprNodes.SubNode):
      # (f - g)' = f' - g'
      return ['-', deriv2(myexpr.operand1, var), deriv2(myexpr.operand2, var)]

   elif isinstance(myexpr, ExprNodes.MulNode):
      #(f * g)' = f * g' + f' * g
      return ['+',
         ['*', myexpr.operand1, deriv2(myexpr.operand2, var)],
         ['*', deriv2(myexpr.operand1, var), myexpr.operand2]]
         
   elif isinstance(myexpr, ExprNodes.PowNode):
      # (f^n)' = n * f^(n-1) * f'
      assert isinstance(myexpr.operand2, ExprNodes.ConstNode)
      return ['*', ['*', myexpr.operand2, ['**', myexpr.operand1, ['-', myexpr.operand2, '1']]], \
          deriv2(myexpr.operand1, var)]

   elif isinstance(myexpr, ExprNodes.NameNode):
      if myexpr.name == var.name:
         return '1'
      else:
         return '0'
         
   elif isinstance(myexpr, ExprNodes.ConstNode):
      return '0'
      
   else:
      print "HEY!", myexpr, myexpr.display(0, 3)
      
def eggs2(a, b):
   return deriv2(5*a+b, a)
   
def eggs3(a, b):
   return deriv2(a**3, a)
   
deftrans exprAndDeriv(expr, var):
   return ['tuple', expr, deriv2(expr, var)]
   
def myfunct(x):
   return exprAndDeriv(5*x**3 - 10, x)
   
def newtons(f, x):
   while True:
      (val, deriv) = f(x)
      print "f(", x, ") =", val, ", f'(", x, ") =", deriv
      if abs(val) < 1e-10:
         return x
      x -= val / deriv

############################################################

# Unrolling the inlining of an array.

deftrans at(array, *indexes):
   expr = indexes[0]
   for i in xrange(1, len(indexes)):
      expr = ['+', ['*', expr, ['strides', array, str(i)]], indexes[i]]
   return ['get', array, expr]

def array_example(myarray, i, j):
    return at(myarray, i, j, 55)
