#cython: boundscheck=False

"""
This is the header file that accompanies the 
"""

from numpy cimport ndarray as ar
import numpy as np
ctypedef unsigned long int size_t

cdef extern from "math.h":
    cdef float ceil(float)

cdef class Point:
    cdef float x,y,z
    cdef void set(self, float, float, float)

############################################################
# geometry types

cdef enum GeomType:
    null, point, box, point_mass

cdef class SpatialObject:
    cdef GeomType gt
    cdef float _density

    cdef _setType(self, GeomType gt)

    cpdef GeomType gtype(self)
    cdef void _setDensity(self, float)
    cpdef ar sample(self, size_t)
    cpdef ar sample_nonrandom(self, size_t)
    cpdef float density(self)
    cpdef float mass(self)

    cpdef bint isInside(self, Point)
    cpdef float volume(self)
    

cdef class PointMass(SpatialObject):
    cdef Point p

    cpdef bint isInside(self, Point)
    cpdef ar sample(self, size_t)
    cpdef ar sample_nonrandom(self, size_t)
    cpdef float volume(self)
    cpdef Point point(self)
    

cdef class Box(SpatialObject):
    cdef:
        float xmin, ymin, zmin
        float xmax, ymax, zmax
        float wx, wy, wz

    cpdef bint isInside(self, Point)
    cpdef ar sample(self, size_t)
    cpdef ar sample_nonrandom(self, size_t)
    cdef tuple get_nonrandom_array_size(self, size_t)
    cdef size_t get_gridsize(self, size_t)
    cdef void setNonrandomSamples(self, ar, size_t)
    cpdef float volume(self)

    cdef void setCoordsDirect(self, Point p1, Point p2)
    cdef void _setWidths(self)


# Utility functions
cpdef bint overlaps(o1, o2)
