from distutils.core import setup
from Cython.Distutils.extension import Extension
from Cython.Distutils.build_ext import build_ext

ext = Extension(
    "rectangle",
    sources = ['rectangle.pyx',
               'cxx/Rectangle.cpp',
               ],
    depends = ['rectangle.pxd',
               'cxx/Rectangle.h',
               ],
    include_dirs=['cxx'],
    language='c++', pyrex_cplus=1,
    )

setup(
    name = 'rectangle',
    version = '0.0.1',
    author = 'Cython Team',
    author_email = 'cython-dev@codespeak.net',
    url = 'http://www.cython.org',
    ext_modules = [ext],
    cmdclass = {'build_ext' : build_ext},
    )
