cimport stdlib
import time
from collections import defaultdict

cdef struct simp:
    unsigned int ll
    float *dta

# unpack the data
cdef float summer_nostruct(float *dta, unsigned int ll):
    cdef int i = 0
    cdef float result = 0.0
    for i from 0 <= i < ll:
        result += dta[i]
    return  result

# copy the struct
cdef float summer_copy(simp sp):
    cdef int i = 0
    cdef float result = 0.0
    for i from 0 <= i < sp.ll:
        result += sp.dta[i]
    return  result

# through pointer dereference
cdef float summer_ptr(simp *sp):
    cdef int i = 0
    cdef float result = 0.0
    for i from 0 <= i < sp.ll:
        result += sp.dta[i]
    return result

def run(unsigned long times, unsigned long repeat, unsigned int dta_l):
    cdef unsigned long i = 0, j = 0
    cdef float result = 0.0
    cdef simp sp
    sp.dta = <float *>stdlib.malloc(sizeof(float)*dta_l)
    sp.ll = dta_l

    for i from 0 <= i < sp.ll:
        sp.dta[i] = i

    mem = defaultdict(list)

    for i from 0 <= i < times:
        t1 = time.clock()
        for j from 0 <= j < repeat:
            result = summer_copy(sp)
        t1 = time.clock() - t1
        mem['copy'].append(t1)

    for i from 0 <= i < times:
        t1 = time.clock()
        for j from 0 <= j < repeat:
            result = summer_ptr(&sp)
        t1 = time.clock() - t1
        mem['ptr'].append(t1)

    for i from 0 <= i < times:
        t1 = time.clock()
        for j from 0 <= j < repeat:
            result = summer_nostruct(sp.dta, sp.ll)
        t1 = time.clock() - t1
        mem['nostruct'].append(t1)


    if sp.dta: stdlib.free(sp.dta)
    sp.dta = NULL
    sp.ll = 0

    return mem, result
