from _benchmarks import run

times = 3
repeats = 10**4, 10**5, 10**6, 10**7
lengths = 10**4, 10**3, 10**2, 10**1

for rep, length in zip(repeats,lengths):
    mem, result = run(times, rep, length)
    print
    print "reps: %d length: %d" % (rep, length)
    for kind in sorted(mem):
        print "%s: %s " % (kind,
                ', '.join([format(n, "5.3f") for n in sorted(mem[kind])]))

# On a Core 2 Duo, 3.16 GHz, 6 MB L2 Cache.
# reps: 10000 length: 10000
# copy: 0.280, 0.280, 0.290
# nostruct: 0.280, 0.290, 0.290
# ptr: 0.280, 0.280, 0.290

# reps: 100000 length: 1000
# copy: 0.280, 0.280, 0.290
# nostruct: 0.280, 0.290, 0.290
# ptr: 0.280, 0.290, 0.290

# reps: 1000000 length: 100
# copy: 0.280, 0.280, 0.300
# nostruct: 0.290, 0.290, 0.290
# ptr: 0.290, 0.290, 0.290

# reps: 10000000 length: 10
# copy: 0.140, 0.150, 0.150
# nostruct: 0.140, 0.140, 0.140
# ptr: 0.140, 0.140, 0.150
