#!/usr/bin/perl

use DBI;
use DBD::Oracle qw(:ora_types);
use Data::Dumper;
use strict;

my $dbh = DBI->connect(
                         "dbi:Oracle:",
                         "scott",
                         "tiger", 
                         { RaiseError => 1, RowCacheSize => 10 } ) or die "Couldn't connect to database: $DBI::errstr\n";
$dbh->{LongReadLen} = 1000000;

print "\n\nfirst: direct table query of clob .. .....\n";
my $csr = $dbh->prepare( "select i, c from mytab", { ora_auto_log => 1 } );
$csr->execute;
my ($i,$c);
$csr->bind_columns( \$i,\$c );
while( $csr->fetch ) { print Dumper [$i,$c] }
$csr->finish;

print "\n\nsecond: clob embedded in user-defined type .....\n";
$csr = $dbh->prepare( "select mytyp(i,c) from mytab", { ora_auto_log => 1 } );
$csr->execute;
my $mytyp;
$csr->bind_columns( \$mytyp );
while( $csr->fetch ) { print Dumper($mytyp) }
$csr->finish;

$dbh->disconnect


