/*
 * Copyright (C) 2002, Nathan Hawkins
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY NATHAN HAWKINS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL JULIE HAUGH OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 */

#ifndef _SHADOW_H
#define _SHADOW_H       1

#define _PATH_SHADOW "/etc/shadow"
#define SHADOW _PATH_SHADOW

struct spwd {
    char *sp_namp;              /* Login name.  */
    char *sp_pwdp;              /* Encrypted password.  */
    long int sp_lstchg;         /* Date of last change.  */
    long int sp_min;            /* Minimum number of days between changes.  */
    long int sp_max;            /* Maximum number of days between changes.  */
    long int sp_warn;           /* Number of days to warn user to change
                                   the password.  */
    long int sp_inact;          /* Number of days the account may be
                                   inactive.  */
    long int sp_expire;         /* Number of days since 1970-01-01 until
                                   account expires.  */
    unsigned long int sp_flag;  /* Reserved.  */
};

extern int fgetspent_r(FILE *,struct spwd *,char *,size_t, struct spwd **);
extern struct spwd *getspent(void);
extern struct spwd *getspnam(const char *);
extern void endspent(void);
extern void setspent(void);

#endif
