#define _GNU_SOURCE
#include <stdio.h>
#include <stdlib.h>
#include <string.h>

#include "my-stuff.h"
#include "mondostructures.h"

#define MDSTAT_FILE "/proc/mdstat" // should go into my-stuff.h

int parse_mdstat(struct s_mdstat *mdstat) {

  const char delims[] = " ";

  FILE *fin;
  int   row;
  char *token, *string, *pos;

  malloc_string(string);

  // open file
  fin = fopen(MDSTAT_FILE, "r");
  // initialise record counter, build progress and row counter
  mdstat->entries = 0;
  mdstat->el[mdstat->entries].progress = 999;
  row = 1;
  // skip first output row - contains registered RAID levels
  fgets(string, MAX_STR_LEN - 1, fin);
  // parse the rest
  while ( fgets(string, MAX_STR_LEN - 1, fin) && !feof(fin) ) {
    // trim leading spaces
    pos = string;
    while (*pos == ' ') *pos++;
    memmove(string, pos, strlen(string));
    //strcpy(string, pos);
    // if we have newline after only spaces, this is a blank line, update
    // counters, otherwise do normal parsing
    if (*string == '\n') {
      row = 1;
      mdstat->entries++;
      mdstat->el[mdstat->entries].progress = 999;
    } else {
      switch (row) {
      case 1:  // device information
	// check whether last line of record and if so skip
	pos = strstr(string, "unused devices: ");
	if (pos == string) {
	  mdstat->entries--;
	  break;
	}
	// tokenise string
	token = strtok (string, delims);
	// get RAID device number
	mdstat->el[mdstat->entries].md = atoi(token + 2);
	// skip ':' and status
	token = strtok (NULL, delims);
	token = strtok (NULL, delims);
	// get RAID level
	token = strtok (NULL, delims);
	if (!strcmp(token, "multipath")) {
	  mdstat->el[mdstat->entries].raidlevel = -2;
	} else if (!strcmp(token, "linear")) {
	  mdstat->el[mdstat->entries].raidlevel = -1;
	} else if (!strcmp(token, "raid0")) {
	  mdstat->el[mdstat->entries].raidlevel = 0;
	} else if (!strcmp(token, "raid1")) {
	  mdstat->el[mdstat->entries].raidlevel = 1;
	} else if (!strcmp(token, "raid4")) {
	  mdstat->el[mdstat->entries].raidlevel = 4;
	} else if (!strcmp(token, "raid5")) {
	  mdstat->el[mdstat->entries].raidlevel = 5;
	} else if (!strcmp(token, "raid6")) {
	  mdstat->el[mdstat->entries].raidlevel = 6;
	} else {
	  printf("ERROR: Unknown RAID level '%s'.\n", token);
	  paranoid_free(string);
	  return 1;
	}
	// get RAID devices (type, index, device)
	mdstat->el[mdstat->entries].disks.entries = -1;
	while((token = strtok (NULL, delims))) {
	  mdstat->el[mdstat->entries].disks.entries++;
	  pos = strstr(token, "(");
	  if (pos) {
	    pos++;
	    mdstat->el[mdstat->entries].disks.el[mdstat->el[mdstat->entries].disks.entries].type = *pos;
	  } else {
	    mdstat->el[mdstat->entries].disks.el[mdstat->el[mdstat->entries].disks.entries].type = ' ';
	  }
	  pos = strstr(token, "[");
	  mdstat->el[mdstat->entries].disks.el[mdstat->el[mdstat->entries].disks.entries].index = atoi(pos + 1);
	  *pos = '\0';
	  strcpy(mdstat->el[mdstat->entries].disks.el[mdstat->el[mdstat->entries].disks.entries].device, token);
	}
	break;
      case 2:  // config information
	// check for super block
	if (strstr(string, "super non-persistent")) {
	  mdstat->el[mdstat->entries].persistent_superblock = -1;
	} else {
	  mdstat->el[mdstat->entries].persistent_superblock = 1;
	}
	// extract chunk size
	if (!(pos = strstr(string, "k chunk"))) {
	  mdstat->el[mdstat->entries].chunk_size = -1;
	} else {
	  while (*pos != ' ') {
	    *pos--;
	    if (pos < string) {
	      printf("ERROR: String underflow!\n");
	      paranoid_free(string);
	      return 1;
	    }
	  }
	  mdstat->el[mdstat->entries].chunk_size = atoi(pos + 1);
	}
	// extract parity if present
	if ((pos = strstr(string, "algorithm"))) {
	  mdstat->el[mdstat->entries].parity = atoi(pos + 9);
	} else {
	  mdstat->el[mdstat->entries].parity = -1;
	}
	break;
      case 3:  // optional build status information
	if (!(pos = strchr(string, '\%'))) {
	  mdstat->el[mdstat->entries].progress = 999;	// not found
	} else if (strstr(string, "DELAYED")) {
	  mdstat->el[mdstat->entries].progress = -1;	// delayed (therefore, stuck at 0%)
	} else {
	  while (*pos != ' ') {
	    *pos--;
	    if (pos < string) {
	      printf("ERROR: String underflow!\n");
	      paranoid_free(string);
	      return 1;
	    }
	  }
	  mdstat->el[mdstat->entries].progress = atoi(pos);
	}
	break;
      default: // error
	printf("ERROR: Row %d should not occur in record!\n", row);
	break;
      }
      row++;
    }
  }
  // close file
  fclose(fin);
  // free string
  paranoid_free(string);
  // return success
  return 0;

}

int main() {

  int res, i, j;
  struct s_mdstat *mdstat;
  
  mdstat = malloc(sizeof(struct s_mdstat));
  
  res = parse_mdstat(mdstat);
  if (res != 0) {
    printf("Parsing mdstat ended with error %d.\n", i);
    return 1;
  }

  for (i=0; i<=mdstat->entries; i++) {
    printf("\n");
    printf("Record #%d\n", i);
    printf("----------------------------------\n");
    printf("   RAID device number: %d\n",  mdstat->el[i].md);
    printf("           RAID level: %d\n",  mdstat->el[i].raidlevel);
    printf("          RAID parity: %d\n",  mdstat->el[i].parity);
    printf("      RAID chunk size: %dk\n", mdstat->el[i].chunk_size);
    for (j=0; j<=mdstat->el[i].disks.entries;j++) {
      printf("--- Disk #%d ---\n", j);
      printf("    Type: (%c)\n", mdstat->el[i].disks.el[j].type);
      printf("   Index: [%d]\n", mdstat->el[i].disks.el[j].index);
      printf("  Device: %s\n", mdstat->el[i].disks.el[j].device);
    }
    printf("RAID build percentage: %d\n", mdstat->el[i].progress);
  }
  
  paranoid_free(mdstat);

  return 0;
  
}
