#!/bin/bash

function print_usage {
	echo 
		echo "copy-new-debs-to-pool [--move] [--keep-old] dir-to-copy add-to-dir"
		echo
		echo "paths must be absolute"
		echo "and must point to the directory in which the pool subdirectory resides"
		echo "The pool directory must have main contrib and non-free subdirectories"
		echo
}

if [ "$1" = "--move" ] ; then
	MOVE=1
	if [ "$2" = "--keep-old" ] ; then
		KEEP=1
	else
		KEEP=0
	fi
else
	MOVE=0
	if [ "$1" = "--keep-old" ] ; then
		KEEP=1
	else
		KEEP=0
	fi
fi

if [ -z "$1" ]; then 
	print_usage
	exit
fi

if [ -z "$2" ]; then
	print_usage
	exit
fi

if [ $MOVE -eq 1 -a -z "$3" ]; then
	print_usage
	exit
else 
	if [ $KEEP -eq 1 -a -z "$3" ]; then
		print_usage
		exit
	fi
fi

if [ $MOVE -eq 1 -a $KEEP -eq 1 -a -z "$4" ]; then
	print_usage
	exit
fi

if [ $MOVE -eq 0  -a $KEEP -eq 0 ]; then
	RC1DIR=$1
	RC2DIR=$2
else 
	if [ $MOVE -eq 1 -a $KEEP -eq 1 ]; then
		RC1DIR=$3
		RC2DIR=$4    
	else
		RC1DIR=$2
		RC2DIR=$3
	fi
fi

echo "Copying from $RC1DIR to $RC2DIR"

TMPFILE=`tempfile`

cd $RC1DIR
find pool -type f | sort >$TMPFILE
rc1base=$RC1DIR
rc2base=$RC2DIR
cd -
for rc1file in `cat $TMPFILE`; do
	pkgfullname=`basename $rc1file`
	pkgname=`echo $pkgfullname | cut -f1 -d_`
	rc1ver=`echo $pkgfullname | cut -f2 -d_`
	pooldir=`dirname $rc1file`
	pkgend=`echo $pkgfullname | cut -f3 -d_`
	rc2file=`ls $rc2base/$pooldir/$pkgname\_*\_$pkgend 2>/dev/null`
	echo $rc2file
	if [ "$rc2file" ]; then
		rc2maxver="!!!!!!!!!!!!!!!!!"
		rc2maxfile="!!!!!!!!!!!!!!!!"
		for rc2match in $rc2file; do
			rc2pkgfullname=`basename $rc2match`
			rc2ver=`echo $rc2pkgfullname | cut -f2 -d_`
			if [ "$rc2ver" ">" "$rc2maxver" ]; 
				then rc2maxver=$rc2ver
				rc2maxfile=$rc2match
			fi
		done
		rc2file=$rc2maxfile
		if [ $rc1ver '>' $rc2maxver ] ; then
			echo "Copying $rc1file newer than $rc2file"
			if [ $MOVE -eq 1 ] ; then
				mv -f $rc1base/$rc1file `dirname $rc2base/$rc1file`
				if [ $KEEP -eq 1 ]; then
					echo "Not  removing obsolete $rc2file"
				else
					echo "Removing obsolete $rc2file"
					rm -f $rc2base/$rc2file
				fi
			else
				cp $rc1base/$rc1file `dirname $rc2base/$rc1file`
				if [ $KEEP -eq 1 ]; then
					echo "Not removing obsolete $rc2file"
				else
					rm -f $rc2base/$rc2file
				fi
			fi
			continue
		fi
		else
			echo "Copying $pkgname not in $RC2DIR"
			install -d $RC2DIR/`dirname $rc1file`
			if [ $MOVE -eq 1 ]; then
				mv -f $RC1DIR/$rc1file `dirname $RC2DIR/$rc1file`
			else
				cp $RC1DIR/$rc1file `dirname $RC2DIR/$rc1file`  
			fi
		fi
done

rm -f $TMPFILE

