#!/bin/sh

function print_usage {
	echo list-files pool-directory
}

if [ -z "$1" ] ; then
print_usage
exit
fi

POOLDIR=$1
TMPFILE=`/bin/tempfile`

if [ `expr substr $POOLDIR 1 1` != \/ ]; then
POOLDIR=`pwd`/$POOLDIR
fi

IFS=$'\n'
for package in `find $POOLDIR -type f`; do 
pkgfilename=`basename $package`
pkgname=`echo $pkgfilename|cut -f1 -d_`
echo $pkgname >> $TMPFILE
done
cat $TMPFILE | sort -u
