#!/bin/bash

function print_usage {
	echo 
		echo "move-installer-udebs source-directory destination-directory"
		echo
		echo "paths must be absolute"
		echo "source-directory is the directory containing the udebs"
		echo "destination-directory is the directory containing the pool directory"
}

if [ -z "$1" ]; then 
print_usage
exit
fi

if [ -z "$2" ]; then
print_usage
exit
fi

SRCDIR=$1
DESTDIR=$2

echo "Copying from $SRCDIR to $DESTDIR"

TMPFILE=/home/khaeos/debian-custom/tempfile

pushd $SRCDIR

find ./ -name "*.udeb" -a -type f | sort > $TMPFILE
srcbase=$SRCDIR
destbase=$DESTDIR
cd -
for srcfile in `cat $TMPFILE`; do
pkgfullname=`basename $srcfile .udeb`
pkgname=`echo $pkgfullname | cut -f1 -d_`
pkgver=`echo $pkgfullname | cut -f2 -d_`
pkgend=`echo $pkgfullname | cut -f3 -d_`
if [ "$pkgend" = $pkgname ]; then
pkgend=`dpkg -I $SRCDIR/$srcfile | awk '''Architecture: '' { print $2 }'`
fi
if [ "$pkgver" = $pkgname ]; then
pkgver=`dpkg -I $SRCDIR/$srcfile | awk '''Version: '' { print $2 }'`
fi
pooldir=`dpkg -I $SRCDIR/$srcfile | awk "Source:"  '{ print $2 }'`
if [ -z "$pooldir" ] ; then
pooldir=$pkgname
fi
poolprefix=`expr substr $pooldir 1 1`
if [ "$poolprefix" = "l" ]; then
poolpref2=`expr substr $pooldir 1 3`
if [ "$poolpref2" = "lib" ] ; then
poolprefix=`expr substr $pooldir 1 4`
else
poolprefix="l"
fi
fi
echo "Copying $pkgname"_"$pkgver"_"$pkgend.udeb to $DESTDIR/pool/main/$poolprefix/$pooldir"
install -d $DESTDIR/pool/main/$poolprefix/$pooldir
cp $SRCDIR/$srcfile $DESTDIR/pool/main/$poolprefix/$pooldir/$pkgname"_"$pkgver"_"$pkgend.udeb
done

rm -f $TMPFILE

popd

