/*
 * bug.c : Program to demonstrate a bug in xdr_pmaplist().  The call to
 * xdr_free() uses some memory after it has already been free'd.  This can lead
 * to a segmentation fault depending on the malloc/free implementation.
 */

#include <rpc/rpc.h>
#include <rpc/pmap_clnt.h>
#include <rpc/pmap_prot.h>
#include <stdlib.h>
#include <stdio.h>
#include <sys/socket.h>
#include <netdb.h>

void
usage (char *name)
{
	fprintf (stderr, "Usage: %s hostname\n", name);
	fprintf (stderr,
		 "'hostname' is a host with RPC services registered.\n");
	fprintf (stderr,
		 "(Hint: 'rpcinfo -p hostname' should return something.)\n");
	exit (EXIT_FAILURE);
}

int
main (int argc, char *argv[])
{
	struct pmaplist *plist;
	struct sockaddr_in peeraddr_in;
	struct hostent *hostent;

	if (argc != 2)
		usage (argv[0]);

	hostent = gethostbyname (argv[1]);

	if (hostent == NULL)
	  {
		  fprintf (stderr, "gethostbyname(%s) failed.\n", argv[1]);
		  exit (EXIT_FAILURE);
	  }

	peeraddr_in.sin_family = AF_INET;
	peeraddr_in.sin_port = 111;
	memcpy (&peeraddr_in.sin_addr, (char *) hostent->h_addr,
		hostent->h_length);
	plist = pmap_getmaps (&peeraddr_in);

	if (NULL == plist)
	  {
		  printf ("Failed to obtain mappings.\n");
		  usage (argv[0]);
	  }
	else
	  {
		  /* Here is the bug, a segmentation fault can occur while
		   * free'ing the structure since xdr_pmaplist() is buggy. */
		  xdr_free ((xdrproc_t) xdr_pmaplist, (char *) &plist);
	  }

	return 0;
}
