#include <QCoreApplication>

#include <akonadi/contact/contactsearchjob.h>
#include "AkonadiInterface.h"

void AkonadiInterface::trigger(QString &email) {
  Akonadi::ContactSearchJob *job = new Akonadi::ContactSearchJob(this);
  job->setLimit(1);

  std::cout << "trying " << email.toUtf8().constData() << std::endl;

  job->setQuery( Akonadi::ContactSearchJob::Email, email );
  QObject::connect( job, SIGNAL( result( KJob* ) ), this, SLOT( searchResult( KJob* ) ) );

}

void AkonadiInterface::searchResult( KJob *job ) {
  Akonadi::ContactSearchJob *searchJob = qobject_cast<Akonadi::ContactSearchJob*>( job );
  const KABC::Addressee::List contacts = searchJob->contacts();

  if ( !contacts.isEmpty() ) {
    std::cout << "success!" << std::endl;
  } else {
    std::cout << "failure!" << std::endl;
  }
}

int main(int argc, char *argv[]) {
  QCoreApplication a(argc, argv);

  if (argc < 2)
    exit(-1);

  QString string = QString(QLatin1String(argv[1]));

  AkonadiInterface *b = new AkonadiInterface();
  b->trigger(string);

  return 0;
}
