package main

import (
	"bufio"
	"context"
	"log"
	"math/rand"
	"os"
	"strings"
	"time"
)

type reader struct {
	l           *lockfile
	lastModTime time.Time
}

func (r *reader) run(ctx context.Context) {
	r.l = &lockfile{file: lockFile}
	ticker := time.NewTicker(10 * time.Millisecond)
	defer ticker.Stop()

	for {
		select {
		case <-ctx.Done():
			return
		case <-ticker.C:
		}

		start := time.Now()
		if err := r.do_read(); err == nil {
			rmetrics.Observe(time.Since(start).Seconds())
		} else {
			log.Printf("do_read: %+v", err)
		}
	}
}

func (r *reader) do_read() error {
	stat, err := os.Stat(listFile)
	if err != nil {
		return err
	}

	modTime := stat.ModTime()
	if !modTime.After(r.lastModTime) {
		return nil
	}

	if err = r.l.Lock(); err != nil {
		return err
	}
	defer r.l.Unlock()

	rfh, err := os.Open(listFile)
	if err != nil {
		return err
	}
	defer rfh.Close()

	wfh, err := os.OpenFile(listFileNew, os.O_CREATE|os.O_WRONLY, 0o600)
	if err != nil {
		return err
	}
	defer wfh.Close()

	rr := bufio.NewReader(rfh)
	wr := bufio.NewWriter(wfh)

	for {
		file, _ := rr.ReadString('\n')
		if file == "" {
			break
		}

		if rand.Intn(10) < 4 { // keep files at 40% chance
			wr.WriteString(file)
		} else {
			file = strings.TrimRight(file, "\n")
			_, err := os.Stat(file)
			if err == nil {
				os.Remove(file)
			} else {
				log.Printf("do_read: stat(%s): %+v", file, err)
			}
		}
	}

	wr.Flush()
	wfh.Close()

	os.Rename(listFileNew, listFile)

	return nil
}
