package main

import (
	"context"
	"fmt"
	"log"
	"math/rand"
	"os"
	"time"
)

type writer struct {
	l *lockfile
}

func (w *writer) run(ctx context.Context) {
	w.l = &lockfile{file: lockFile}
	ticker := time.NewTicker(10 * time.Millisecond)
	defer ticker.Stop()

	for {
		select {
		case <-ctx.Done():
			return
		case <-ticker.C:
		}

		start := time.Now()
		if err := w.do_write(); err == nil {
			wmetrics.Observe(time.Since(start).Seconds())
		} else {
			log.Printf("do_write: %+v", err)
		}
	}
}

func (w *writer) do_write() error {
	nfiles := 1 + rand.Intn(10)

	if err := w.l.Lock(); err != nil {
		return err
	}
	defer w.l.Unlock()

	fh, err := os.OpenFile(listFile, os.O_CREATE|os.O_WRONLY|os.O_APPEND, 0o600)
	if err != nil {
		return err
	}
	defer fh.Close()

	for i := 0; i < nfiles; i++ {
		fname := fmt.Sprintf("file-%d.%d", time.Now().Nanosecond(), rand.Int())
		if err = os.WriteFile(fname, []byte(fname), 0o600); err == nil {
			fh.Write([]byte(fmt.Sprintf("%s\n", fname)))
		} else {
			log.Printf("do_write: writefile: %+v", err)
		}
	}

	return nil
}
