package main

import (
	"math/rand"
	"os"
	"time"
)

type lockfile struct {
	file string
	fh   *os.File
}

func (l *lockfile) Lock() (err error) {
	i := 0

	for {
		if _, err = os.Stat(l.file); err != nil && os.IsNotExist(err) {
			l.fh, err = os.OpenFile(l.file, os.O_CREATE|os.O_RDWR|os.O_EXCL, 0o644)
			if err == nil {
				return
			}
		} else {
			err = os.ErrExist
		}

		i++
		if i == 15 {
			return
		}

		time.Sleep(time.Millisecond * time.Duration((1 + rand.Intn(10))))
	}
}

func (l *lockfile) Unlock() (err error) {
	if l.fh == nil {
		return
	}

	l.fh.Close()

	os.Remove(l.file)

	return
}
