package main

import (
	"context"
	"fmt"
	"log"
	"math/rand"
	"os"
	"time"
)

type writer struct {
	l *lockfile
}

func (w *writer) run(ctx context.Context, instance int) {
	m := pmetrics.WithLabelValues(fmt.Sprintf("%d", instance), "write")

	w.l = &lockfile{file: lockFile}

	wd := make(chan bool)

	go func() {
		timer := time.NewTimer(time.Second)
		defer timer.Stop()

		for {
			select {
			case <-ctx.Done():
				return
			case <-timer.C:
				log.Printf("writer(%d) has been blocked for a second", instance)
				return
			case <-wd:
				if !timer.Stop() {
					<-timer.C
				}
				timer.Reset(time.Second)
			}
		}
	}()

	for {
		select {
		case <-ctx.Done():
			return
		default:
		}

		start := time.Now()
		if err := w.do_write(); err == nil {
			m.Observe(time.Since(start).Seconds())
		}

		wd <- true
	}
}

func (w *writer) do_write() error {
	if err := w.l.Lock(); err != nil {
		return err
	}
	defer w.l.Unlock()

	fh, err := os.OpenFile(listFile, os.O_CREATE|os.O_WRONLY|os.O_APPEND, 0o600)
	if err != nil {
		return err
	}
	defer fh.Close()

	line := fmt.Sprintf("file-%d.%d\n", time.Now().Nanosecond(), rand.Int())
	fh.Write([]byte(line))

	return nil
}
