package main

import (
	"bufio"
	"context"
	"log"
	"math/rand"
	"os"
	"time"
)

type reader struct {
	l           *lockfile
	lastModTime time.Time
}

func (r *reader) run(ctx context.Context, instance int) {
	r.l = &lockfile{file: lockFile}

	wd := make(chan bool)

	go func() {
		timer := time.NewTimer(time.Second)
		defer timer.Stop()

		for {
			select {
			case <-ctx.Done():
				return
			case <-timer.C:
				log.Printf("reader(%d) has been blocked for a second", instance)
				return
			case <-wd:
				if !timer.Stop() {
					<-timer.C
				}
				timer.Reset(time.Second)
			}
		}
	}()

	for {
		select {
		case <-ctx.Done():
			return
		default:
		}

		r.do_read()

		wd <- true
	}
}

func (r *reader) do_read() error {
	stat, err := os.Stat(listFile)
	if err != nil {
		return err
	}

	modTime := stat.ModTime()
	if !modTime.After(r.lastModTime) {
		return nil
	}

	if err = r.l.Lock(); err != nil {
		return err
	}
	defer r.l.Unlock()

	rfh, err := os.Open(listFile)
	if err != nil {
		return err
	}
	defer rfh.Close()

	wfh, err := os.OpenFile(listFileNew, os.O_CREATE|os.O_WRONLY, 0o600)
	if err != nil {
		return err
	}
	defer wfh.Close()

	rr := bufio.NewReader(rfh)
	wr := bufio.NewWriter(wfh)

	for {
		line, _ := rr.ReadString('\n')
		if line == "" {
			break
		}

		if rand.Intn(10) < 4 { // keep files at 40% chance
			wr.WriteString(line)
		}
	}

	wr.Flush()
	wfh.Close()

	os.Rename(listFileNew, listFile)

	return nil
}
