#! /bin/sh
set -e

if [ "x$1" != x--upstream-version ]; then
	exit 1
fi

version="$2"
filename="$3"
dversion="$version+dfsg1"
dfilename=`echo $filename|sed "s/$version/$dversion/"`

if [ -z "$version" -o ! -r "$filename" ]; then
	echo >&2 "E: need an existing tarball as the second argument."
	exit 1
fi

TMP="`mktemp -d -t`"
MANIFEST="`mktemp -t`"
TMP_TAR="`mktemp -t`"
TARBALL="`basename $filename`"
trap "rm -rf $TMP; rm -f $TMP_TAR; rm -f $TM_TAR.gz; rm -f $MANIFEST" 0

tar pxCf "$TMP" "$filename"
(
	# filter non dfsg files
	tar tf "$filename"|sed 's/^\.*\/*//' \
	     |egrep -v "^[^/]+/doc/html(/.*)?$" \
	     |egrep -v "^[^/]+/doc/modules/images/.*\.png$" \
	     |egrep -v "^[^/]+/examples/resources/hello\.bmp$" \
	     > "$MANIFEST"

	cd "$TMP"
	tar cf "$TMP_TAR" --owner 0 --group 0 --numeric-owner --files-from "$MANIFEST" --no-recursion
	gzip -n -m -f "$TMP_TAR"
)
mv "$TMP_TAR".gz "$dfilename"
echo "Pruned $dfilename"

