#! /bin/sh
### BEGIN INIT INFO
# Provides:          checkbootmd5
# Required-Start:    checkroot
# Required-Stop:
# Should-Start:
# Should-Stop:
# Default-Start:     S
# Default-Stop:
# Short-Description: Checks /boot device for manipulation via md5sum
### END INIT INFO

. /lib/init/vars.sh

. /lib/lsb/init-functions

do_start () {
	#OLD=$(cat /bootmd5)
	#NEW=$(md5sum /dev/sda1)
	echo .
        find /boot -type f > /bootmd5-filelist
	#echo OLD: $OLD
	#echo NEW: $NEW
	#if [ "$OLD" != "$NEW" ]
	md5sum -c /bootmd5
	if [ $? -ne 0 ]
	then
		echo -n -e "\007"
		sleep 0.1
		echo -n -e "\007"
		sleep 0.1
		echo -n -e "\007"
		sleep 0.5
		echo -n -e "\007"
		sleep 0.5
		echo -n -e "\007"
		sleep 0.5
		echo -n -e "\007"
		sleep 0.1
		echo -n -e "\007"
		sleep 0.1
		echo -n -e "\007"
		echo "BOOT partition has changed!"
		echo "update the md5 database (y/N) ?"
		read -s -n 1 -t 30
		if [ $? -eq 0 -a "$REPLY" = "y" ]
		then
			/usr/local/sbin/update-bootmd5.sh
			echo "bootmd5 database updated"
		else
			echo "bootmd5 database not updated, it remains broken"
		fi
		#sleep 30
	fi
}

case "$1" in
  start|"")
	log_action_begin_msg "Checking boot md5sum"
	do_start
	;;
  restart|reload|force-reload)
	echo "Error: argument '$1' not supported" >&2
	exit 3
	;;
  stop)
	# No-op
	;;
  *)
	echo "Usage: checkmd5.sh [start]" >&2
	exit 3
	;;
esac

:
